/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.Comparison;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.builder.DefaultVPMBuilderService;
import org.splevo.vpm.builder.VPMBuildException;
import org.splevo.vpm.variability.VariationPointModel;

public class InitVPMJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private SPLevoProject splevoProject;

    public InitVPMJob(SPLevoProject splevoProject) {
        this.splevoProject = splevoProject;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        VariationPointModel vpm;
        this.logger.info((Object)"Get comparison model");
        Comparison comparison = ((SPLevoBlackBoard)this.getBlackboard()).getDiffModel();
        if (comparison == null) {
            throw new JobFailedException("No Diff model available on blackboard");
        }
        this.logger.info((Object)"Build initial VPM model");
        LinkedHashMap builderOptions = new LinkedHashMap();
        DefaultVPMBuilderService builderService = new DefaultVPMBuilderService();
        try {
            vpm = builderService.buildVPM(comparison, this.splevoProject.getVariantNameLeading(), this.splevoProject.getVariantNameIntegration(), builderOptions);
        }
        catch (VPMBuildException e) {
            throw new JobFailedException("Failed to initialize the VPM model", (Throwable)e);
        }
        if (monitor.isCanceled()) {
            monitor.done();
            this.logger.info((Object)"Workflow cancled.");
            return;
        }
        this.logger.info((Object)"Store VPM model in blackboard");
        ((SPLevoBlackBoard)this.getBlackboard()).setVariationPointModel(vpm);
        monitor.done();
    }

    public String getName() {
        return "Init VPM model Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

