/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.splevo.diffing.DiffingModelUtil;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.commons.util.JobUtil;
import org.splevo.ui.jobs.SPLevoBlackBoard;

public class LoadDiffingModelJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private SPLevoProject splevoProject;

    public LoadDiffingModelJob(SPLevoProject splevoProject) {
        this.splevoProject = splevoProject;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException {
        Comparison diffModel;
        this.logger.info((Object)"Load diff models");
        File diffModelFile = new File(this.splevoProject.getDiffingModelPath());
        ResourceSet resourceSet = JobUtil.initResourceSet((SPLevoProject)this.splevoProject, (boolean)false);
        try {
            diffModel = DiffingModelUtil.loadModel((File)diffModelFile, (ResourceSet)resourceSet);
        }
        catch (IOException e) {
            throw new JobFailedException("Failed to load diff model.", (Throwable)e);
        }
        this.logger.info((Object)"Put diff model on the blackboard");
        ((SPLevoBlackBoard)this.getBlackboard()).setDiffModel(diffModel);
        monitor.done();
    }

    public String getName() {
        return "Load diffing model Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

