/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.listeners;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Shell;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.listeners.WorkflowListenerUtil;
import org.splevo.ui.workflow.BasicSPLevoWorkflowConfiguration;
import org.splevo.ui.workflow.GenerateFeatureModelWorkflowDelegate;

public class GenerateFeatureModelListener
extends MouseAdapter {
    private SPLevoProjectEditor splevoProjectEditor = null;

    public GenerateFeatureModelListener(SPLevoProjectEditor splevoProjectEditor) {
        this.splevoProjectEditor = splevoProjectEditor;
    }

    public void mouseUp(MouseEvent e) {
        BasicSPLevoWorkflowConfiguration config = this.buildWorflowConfiguration();
        Shell shell = e.widget.getDisplay().getActiveShell();
        if (!config.isValid()) {
            MessageDialog.openError((Shell)shell, (String)"Invalid Project Configuration", (String)config.getErrorMessage());
            return;
        }
        if (config.getSplevoProjectEditor().getSplevoProject().getVpmModelReferences().size() == 0) {
            MessageDialog.openError((Shell)shell, (String)"Variation Point Model Missing", (String)"There is no variation point model available to generate a feature model from.");
            return;
        }
        GenerateFeatureModelWorkflowDelegate delegate = new GenerateFeatureModelWorkflowDelegate(config);
        String title = "Generate Feature Model";
        WorkflowListenerUtil.runWorkflowAndUpdateUI(delegate, title, this.splevoProjectEditor);
    }

    private BasicSPLevoWorkflowConfiguration buildWorflowConfiguration() {
        BasicSPLevoWorkflowConfiguration config = new BasicSPLevoWorkflowConfiguration();
        config.setSplevoProjectEditor(this.splevoProjectEditor);
        return config;
    }
}

