/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.nature;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.splevo.project.ProjectFactory;
import org.splevo.project.SPLevoProject;
import org.splevo.project.utils.SPLevoProjectUtil;

public class SPLevoNature
implements IProjectNature {
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.splevo.ui.splevobuilder")) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.splevo.ui.splevobuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
        String splevoProjectFileName = String.valueOf(this.project.getName()) + "." + "splevoproject";
        File filePath = new File(String.valueOf(this.project.getFullPath().toString()) + File.separator + splevoProjectFileName);
        String workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        File absolutePath = new File(String.valueOf(workspaceRoot) + filePath.toString());
        if (!absolutePath.exists()) {
            SPLevoProject projectConfiguration = ProjectFactory.eINSTANCE.createSPLevoProject();
            projectConfiguration.setWorkspace(String.valueOf(this.project.getName()) + "/");
            projectConfiguration.setName(this.project.getName());
            try {
                SPLevoProjectUtil.save((SPLevoProject)projectConfiguration, (File)filePath);
                this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                IFile file = this.project.getFile(splevoProjectFileName);
                FileEditorInput inputFile = new FileEditorInput(file);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)inputFile, "org.splevo.ui.editors.SPLevoProjectEditor");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.splevo.ui.splevobuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static String getNatureId() {
        return "org.splevo.ui.splevonature";
    }
}

