/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.splevo.ui.SPLevoUIPlugin;
import org.splevo.ui.sourceconnection.SourceEditorConnector;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementReason;
import org.splevo.vpm.variability.VariationPoint;

public class RefinementGraph
extends Graph {
    private static final Color COLOR_CONNECTION_HIGHLIGHT = SPLevoUIPlugin.COLOR_ORANGE;
    private static final Color COLOR_CONNECTION_FOCUSED = SPLevoUIPlugin.COLOR_MEDIUM_BLUE;
    private static final Color COLOR_CONNECTION_NOTFOCUSED = SPLevoUIPlugin.COLOR_LIGHT_BLUE;
    private static final Color COLOR_NODE_HIGHLIGHT = SPLevoUIPlugin.COLOR_ORANGE;
    private static final Color COLOR_NODE_BACKGROUND_FOCUSED = SPLevoUIPlugin.COLOR_MEDIUM_BLUE;
    private static final Color COLOR_NODE_BACKGROUND_NOTFOCUSED = SPLevoUIPlugin.COLOR_LIGHT_BLUE;
    private static final String NODE_DATA_KEY_VP = "node.data.key.vp";
    private LinkedHashMap<VariationPoint, GraphNode> nodeIndex = Maps.newLinkedHashMap();
    private Refinement focusedRefinement = null;
    private Multimap<GraphNode, GraphNode> connectedNodes = LinkedHashMultimap.create();

    RefinementGraph(Composite parent, int style) {
        super(parent, style);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object conObject : RefinementGraph.this.getConnections()) {
                    GraphConnection con = (GraphConnection)conObject;
                    con.unhighlight();
                }
                for (Object selectedItem : RefinementGraph.this.getSelection()) {
                    if (!(selectedItem instanceof GraphNode)) continue;
                    GraphNode node = (GraphNode)selectedItem;
                    this.hightlightConnections(node);
                }
            }

            private void hightlightConnections(GraphNode node) {
                ArrayList connections = Lists.newArrayList();
                connections.addAll(node.getSourceConnections());
                connections.addAll(node.getTargetConnections());
                for (Object conObject : connections) {
                    GraphConnection con = (GraphConnection)conObject;
                    con.highlight();
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ArrayList openFiles = Lists.newArrayList();
                for (Object selectedItem : RefinementGraph.this.getSelection()) {
                    GraphNode node;
                    if (!(selectedItem instanceof GraphNode) || (node = (GraphNode)selectedItem).getData(RefinementGraph.NODE_DATA_KEY_VP) == null) continue;
                    VariationPoint vp = (VariationPoint)node.getData(RefinementGraph.NODE_DATA_KEY_VP);
                    SourceEditorConnector.openVariationPoint(vp, openFiles);
                }
            }
        });
    }

    public void show(Refinement refinement) {
        this.clear();
        this.focusedRefinement = refinement;
        if (refinement.eContainer() instanceof Refinement) {
            this.createGraphNodes((Refinement)refinement.eContainer());
        } else {
            this.createGraphNodes(refinement);
        }
        this.setLayoutAlgorithm((LayoutAlgorithm)new SpringLayoutAlgorithm(3), true);
        this.layout();
    }

    private void createGraphNodes(Refinement refinement) {
        for (VariationPoint vp : refinement.getVariationPoints()) {
            this.createNode(vp);
        }
        for (Refinement subRefinement : refinement.getSubRefinements()) {
            this.createGraphNodes(subRefinement);
        }
        this.createConnections(refinement);
    }

    private void createNode(VariationPoint vp) {
        GraphNode vpNode = new GraphNode((IContainer)this, 8, "VP", SPLevoUIPlugin.KOPL_ICON);
        vpNode.setData(NODE_DATA_KEY_VP, (Object)vp);
        if (this.isFocused(vp)) {
            vpNode.setBackgroundColor(COLOR_NODE_BACKGROUND_FOCUSED);
        } else {
            vpNode.setBackgroundColor(COLOR_NODE_BACKGROUND_NOTFOCUSED);
        }
        vpNode.setHighlightColor(COLOR_NODE_HIGHLIGHT);
        vpNode.setBorderHighlightColor(vpNode.getBorderColor());
        vpNode.setTooltip((IFigure)new Label(vp.getLocation().getLabel()));
        this.nodeIndex.put(vp, vpNode);
    }

    private void createConnections(Refinement refinement) {
        int connectionStyle = 2;
        for (RefinementReason reason : refinement.getReasons()) {
            GraphNode target;
            VariationPoint sourceVP = reason.getSource();
            VariationPoint targetVP = reason.getTarget();
            GraphNode source = this.nodeIndex.get(sourceVP);
            if (!this.isValidNewConnection(source, target = this.nodeIndex.get(targetVP))) continue;
            GraphConnection connection = new GraphConnection((Graph)this, connectionStyle, source, target);
            connection.setHighlightColor(COLOR_CONNECTION_HIGHLIGHT);
            if (!this.areFocused(sourceVP, targetVP)) {
                connection.setLineStyle(2);
                connection.setLineColor(COLOR_CONNECTION_NOTFOCUSED);
            } else {
                connection.setLineColor(COLOR_CONNECTION_FOCUSED);
            }
            connection.setTooltip((IFigure)new Label(reason.getReason()));
            this.connectedNodes.put((Object)source, (Object)target);
        }
    }

    private boolean isValidNewConnection(GraphNode source, GraphNode target) {
        if (source == null || target == null) {
            return false;
        }
        if (this.connectedNodes.get((Object)source).contains(target)) {
            return false;
        }
        return !this.connectedNodes.get((Object)target).contains(source);
    }

    private boolean areFocused(VariationPoint vp1, VariationPoint vp2) {
        return this.isFocused(vp1) && this.isFocused(vp2);
    }

    private boolean isFocused(VariationPoint vp) {
        return this.focusedRefinement.getVariationPoints().contains((Object)vp);
    }

    public void clear() {
        Object[] connectionArray;
        Object[] nodeArray;
        this.nodeIndex.clear();
        this.connectedNodes.clear();
        this.focusedRefinement = null;
        Object[] objectArray = nodeArray = this.getNodes().toArray();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object nodeObj = objectArray[n2];
            ((GraphNode)nodeObj).dispose();
            ++n2;
        }
        Object[] objectArray2 = connectionArray = this.getConnections().toArray();
        int n3 = connectionArray.length;
        n = 0;
        while (n < n3) {
            Object connectionObj = objectArray2[n];
            ((GraphConnection)connectionObj).dispose();
            ++n;
        }
        this.layout();
    }
}

