/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection.handler;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.splevo.ui.editors.UnifiedDiffEditor;
import org.splevo.ui.sourceconnection.UnifiedDiffConnectorModel;
import org.splevo.ui.sourceconnection.helper.FileLineNumberPair;

public class OpenUnifiedDiffSourceHandler
extends AbstractHandler {
    private static final Logger LOGGER = Logger.getLogger(OpenUnifiedDiffSourceHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorPart editorPart = window.getActivePage().getActiveEditor();
        if (editorPart instanceof UnifiedDiffEditor) {
            ISelectionProvider selectionProvider;
            UnifiedDiffEditor editor = (UnifiedDiffEditor)editorPart;
            IEditorSite editorSite = editor.getEditorSite();
            if (editorSite != null && (selectionProvider = editorSite.getSelectionProvider()) != null) {
                ISelection selection = selectionProvider.getSelection();
                int selectedLineNumber = ((ITextSelection)selection).getStartLine();
                UnifiedDiffConnectorModel content = editor.getDiffConnectorModel();
                if (content != null) {
                    List<FileLineNumberPair> sources = content.getFileInformationFor(selectedLineNumber);
                    IEditorPart openedEditor = null;
                    for (FileLineNumberPair source : sources) {
                        if (source.getFile().exists() && source.getFile().isFile()) {
                            openedEditor = this.openSourceInEditor(workbench, source.getFile());
                            this.selectAndReveal(openedEditor, source);
                            continue;
                        }
                        LOGGER.error((Object)("The source file (to open) \"" + source.getFile().getAbsolutePath() + "\" does not exist!"));
                    }
                } else {
                    LOGGER.error((Object)"Could not fetch unified connector content!");
                }
            }
        } else {
            LOGGER.error((Object)("The active editor is not of type " + UnifiedDiffEditor.class.getName() + " but " + editorPart.getClass().getName()));
        }
        return null;
    }

    private IEditorPart openSourceInEditor(IWorkbench workbench, File source) {
        IEditorPart editor = null;
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        try {
            editor = window.getActivePage().openEditor(this.createEditorInput(source), editorRegistry.getDefaultEditor(source.getName()).getId());
        }
        catch (PartInitException e) {
            LOGGER.error((Object)("Default source editor for source \"" + source.getAbsolutePath() + "\" could not be opened!"), (Throwable)e);
        }
        return editor;
    }

    private void selectAndReveal(IEditorPart editor, FileLineNumberPair fileInformation) {
        AbstractDecoratedTextEditor specificEditor = (AbstractDecoratedTextEditor)editor;
        IEditorInput input = specificEditor.getEditorInput();
        IDocument document = specificEditor.getDocumentProvider().getDocument((Object)input);
        if (document != null) {
            IRegion lineInfo = null;
            try {
                lineInfo = document.getLineInformation(fileInformation.getLineNumber() - 1);
            }
            catch (BadLocationException e) {
                LOGGER.error((Object)("The selected line " + (fileInformation.getLineNumber() - 1) + " could not be found within source file \"" + fileInformation.getFile().getAbsolutePath() + "\"!"), (Throwable)e);
            }
            if (lineInfo != null) {
                specificEditor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
            }
        }
    }

    private IEditorInput createEditorInput(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile ifile = workspace.getRoot().getFileForLocation(location);
        return new FileEditorInput(ifile);
    }
}

