/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection.jdt;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.splevo.ui.sourceconnection.jdt.VariantRegistry;
import org.splevo.ui.sourceconnection.jdt.VartiantLinkQuickFix;
import org.splevo.vpm.variability.Variant;

public class VariantLinkQuickFixGenerator
implements IMarkerResolutionGenerator {
    private Logger logger = Logger.getLogger(VariantLinkQuickFixGenerator.class);

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            Object variantKey = marker.getAttribute("org.splevo.ui.markers.attribute.variant");
            if (variantKey instanceof String) {
                Variant variant = VariantRegistry.get((String)variantKey);
                if (variant != null) {
                    return this.buildAlternativeVariantLinks(variant);
                }
                this.logger.warn((Object)String.format("No variant registered for variant attribure: %s", variantKey));
            }
        }
        catch (CoreException e) {
            this.logger.warn((Object)"Error accessing marker attribute", (Throwable)e);
        }
        return new IMarkerResolution[0];
    }

    private IMarkerResolution[] buildAlternativeVariantLinks(Variant currentVariant) {
        LinkedList resolutions = Lists.newLinkedList();
        for (Variant alternativeVariant : currentVariant.getVariationPoint().getVariants()) {
            if (alternativeVariant == currentVariant) continue;
            resolutions.add(new VartiantLinkQuickFix(alternativeVariant));
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }
}

