/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.vpmgraph;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.wb.swt.ResourceManager;
import org.graphstream.graph.Node;
import org.splevo.ui.views.vpmgraph.VPMGraphView;

class FilterSingleNodeAction
extends Action {
    private static final String ICON_ACTIVE = "icons/active/filter-empty-nodes.png";
    private Logger logger = Logger.getLogger(FilterSingleNodeAction.class);
    private VPMGraphView vpmGraphView;
    private static final String NODE_ATTRIBUTE_HIDE = "ui.hide";

    public FilterSingleNodeAction(VPMGraphView vpmGraphView) {
        super("Filter Single Nodes Action", 2);
        this.vpmGraphView = vpmGraphView;
        this.setToolTipText("Show single nodes without relationships");
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor("org.splevo.ui", ICON_ACTIVE));
        this.setChecked(false);
    }

    public void run() {
        if (this.vpmGraphView.getVpmGraph() == null) {
            this.logger.warn((Object)"No VPMGraph present in VPMGraph view.");
            return;
        }
        this.toggleNodes();
    }

    private void toggleNodes() {
        if (this.isChecked()) {
            for (Node currentNode : this.vpmGraphView.getVpmGraph().getNodeSet()) {
                if (currentNode.getDegree() != 0) continue;
                currentNode.addAttribute(NODE_ATTRIBUTE_HIDE, new Object[0]);
            }
        } else {
            for (Node currentNode : this.vpmGraphView.getVpmGraph().getNodeSet()) {
                if (currentNode.getDegree() != 0) continue;
                currentNode.removeAttribute(NODE_ATTRIBUTE_HIDE);
            }
        }
    }
}

