/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.framework.Bundle;

public class ResourceManager
extends SWTResourceManager {
    private static Map<ImageDescriptor, Image> descriptorImageMap = new HashMap<ImageDescriptor, Image>();
    private static Logger logger = Logger.getLogger(ResourceManager.class);
    private static Map<Image, Map<Image, Image>>[] decoratedImageMap = new Map[5];
    private static Map<String, Image> urlImageMap = new HashMap<String, Image>();
    private static PluginResourceProvider designTimePluginResourceProvider = null;

    public static ImageDescriptor getImageDescriptor(Class<?> clazz, String path) {
        return ImageDescriptor.createFromFile(clazz, (String)path);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new File(path).toURI().toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = descriptorImageMap.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            descriptorImageMap.put(descriptor, image);
        }
        return image;
    }

    public static Image decorateImage(Image baseImage, Image decorator) {
        return ResourceManager.decorateImage(baseImage, decorator, 4);
    }

    public static Image decorateImage(final Image baseImage, final Image decorator, final int corner) {
        Image result;
        Map<Image, Image> decoratedMap;
        if (corner <= 0 || corner >= 5) {
            throw new IllegalArgumentException("Wrong decorate corner");
        }
        Map<Image, Map<Image, Image>> cornerDecoratedImageMap = decoratedImageMap[corner];
        if (cornerDecoratedImageMap == null) {
            ResourceManager.decoratedImageMap[corner] = cornerDecoratedImageMap = new HashMap<Image, Map<Image, Image>>();
        }
        if ((decoratedMap = cornerDecoratedImageMap.get(baseImage)) == null) {
            decoratedMap = new HashMap<Image, Image>();
            cornerDecoratedImageMap.put(baseImage, decoratedMap);
        }
        if ((result = decoratedMap.get(decorator)) == null) {
            final Rectangle bib = baseImage.getBounds();
            final Rectangle dib = decorator.getBounds();
            final Point baseImageSize = new Point(bib.width, bib.height);
            CompositeImageDescriptor compositImageDesc = new CompositeImageDescriptor(){

                protected void drawCompositeImage(int width, int height) {
                    this.drawImage(baseImage.getImageData(), 0, 0);
                    if (corner == 1) {
                        this.drawImage(decorator.getImageData(), 0, 0);
                    } else if (corner == 2) {
                        this.drawImage(decorator.getImageData(), bib.width - dib.width, 0);
                    } else if (corner == 3) {
                        this.drawImage(decorator.getImageData(), 0, bib.height - dib.height);
                    } else if (corner == 4) {
                        this.drawImage(decorator.getImageData(), bib.width - dib.width, bib.height - dib.height);
                    }
                }

                protected Point getSize() {
                    return baseImageSize;
                }
            };
            result = compositImageDesc.createImage();
            decoratedMap.put(decorator, result);
        }
        return result;
    }

    public static void disposeImages() {
        SWTResourceManager.disposeImages();
        Iterator<Image> imageIterator = descriptorImageMap.values().iterator();
        while (imageIterator.hasNext()) {
            imageIterator.next().dispose();
        }
        descriptorImageMap.clear();
        int i = 0;
        while (i < decoratedImageMap.length) {
            Map<Image, Map<Image, Image>> cornerDecoratedImageMap = decoratedImageMap[i];
            if (cornerDecoratedImageMap != null) {
                for (Map<Image, Image> decoratedMap : cornerDecoratedImageMap.values()) {
                    for (Image image : decoratedMap.values()) {
                        image.dispose();
                    }
                    decoratedMap.clear();
                }
                cornerDecoratedImageMap.clear();
            }
            ++i;
        }
        imageIterator = urlImageMap.values().iterator();
        while (imageIterator.hasNext()) {
            imageIterator.next().dispose();
        }
        urlImageMap.clear();
    }

    @Deprecated
    public static Image getPluginImage(Object plugin, String name) {
        try {
            URL url = ResourceManager.getPluginImageURL(plugin, name);
            if (url != null) {
                return ResourceManager.getPluginImageFromUrl(url);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Failed to get plugin image", e);
        }
        return null;
    }

    public static Image getPluginImage(String symbolicName, String path) {
        try {
            URL url = ResourceManager.getPluginImageURL(symbolicName, path);
            if (url != null) {
                return ResourceManager.getPluginImageFromUrl(url);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Failed to get plugin image", e);
        }
        return null;
    }

    private static Image getPluginImageFromUrl(URL url) {
        try {
            String key = url.toExternalForm();
            Image image = urlImageMap.get(key);
            if (image == null) {
                InputStream stream = url.openStream();
                try {
                    image = ResourceManager.getImage(stream);
                    urlImageMap.put(key, image);
                }
                finally {
                    stream.close();
                }
            }
            return image;
        }
        catch (Throwable e) {
            logger.warn((Object)"Failed to get plugin image", e);
            return null;
        }
    }

    @Deprecated
    public static ImageDescriptor getPluginImageDescriptor(Object plugin, String name) {
        try {
            URL url = ResourceManager.getPluginImageURL(plugin, name);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (Throwable e) {
            logger.warn((Object)"Failed to get plugin image", e);
            return null;
        }
    }

    public static ImageDescriptor getPluginImageDescriptor(String symbolicName, String path) {
        try {
            URL url = ResourceManager.getPluginImageURL(symbolicName, path);
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Failed to get plugin image", e);
        }
        return null;
    }

    private static URL getPluginImageURL(String symbolicName, String path) {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null) {
            return bundle.getEntry(path);
        }
        if (designTimePluginResourceProvider != null) {
            return designTimePluginResourceProvider.getEntry(symbolicName, path);
        }
        return null;
    }

    private static URL getPluginImageURL(Object plugin, String name) throws Exception {
        try {
            Class<?> bundleClass = Class.forName("org.osgi.framework.Bundle");
            Class<?> bundleContextClass = Class.forName("org.osgi.framework.BundleContext");
            if (bundleContextClass.isAssignableFrom(plugin.getClass())) {
                Method getBundleMethod = bundleContextClass.getMethod("getBundle", new Class[0]);
                Object bundle = getBundleMethod.invoke(plugin, new Object[0]);
                Class<?> pathClass = Class.forName("org.eclipse.core.runtime.Path");
                Constructor<?> pathConstructor = pathClass.getConstructor(String.class);
                Object path = pathConstructor.newInstance(name);
                Class<?> iPathClass = Class.forName("org.eclipse.core.runtime.IPath");
                Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
                Method findMethod = platformClass.getMethod("find", bundleClass, iPathClass);
                return (URL)findMethod.invoke(null, bundle, path);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Failed to get plugin image", e);
        }
        Class<?> pluginClass = Class.forName("org.eclipse.core.runtime.Plugin");
        if (pluginClass.isAssignableFrom(plugin.getClass())) {
            Class<?> pathClass = Class.forName("org.eclipse.core.runtime.Path");
            Constructor<?> pathConstructor = pathClass.getConstructor(String.class);
            Object path = pathConstructor.newInstance(name);
            Class<?> iPathClass = Class.forName("org.eclipse.core.runtime.IPath");
            Method findMethod = pluginClass.getMethod("find", iPathClass);
            return (URL)findMethod.invoke(plugin, path);
        }
        return null;
    }

    public static void dispose() {
        ResourceManager.disposeColors();
        ResourceManager.disposeFonts();
        ResourceManager.disposeImages();
    }

    public static interface PluginResourceProvider {
        public URL getEntry(String var1, String var2);
    }
}

