/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.dashboard;

import com.google.common.collect.Iterables;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.mihalis.opal.header.Header;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.dashboard.AbstractDashboardTab;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.listeners.GenerateFeatureModelListener;
import org.splevo.ui.listeners.InitVPMListener;
import org.splevo.ui.listeners.OpenVPMListener;
import org.splevo.ui.listeners.StartRefactoringListener;
import org.splevo.ui.listeners.VPMAnalysisListener;
import org.splevo.ui.listeners.WorkflowListenerUtil;
import org.splevo.ui.vpexplorer.util.VPMUIUtil;
import org.splevo.ui.workflow.BuildSPLWorkflowConfiguration;
import org.splevo.ui.workflow.SnapshotSPLWorkflowDelegate;

public class ProcessControlTab
extends AbstractDashboardTab {
    private Button initVpmBtn;
    private Button analyzeVPMBtn;
    private Button startRefactoringBtn;
    private Button generateFMBtn;
    private Button openVPMBtn;
    private TableViewer tableViewer;
    private List<VPMModelReference> vpmInput;
    private Map<Object, Button> reverseButtons;

    public ProcessControlTab(SPLevoProjectEditor splevoProjectEditor, TabFolder tabFolder, int tabIndex) {
        super(splevoProjectEditor);
        this.createTab(tabFolder, tabIndex);
    }

    private void createTab(TabFolder tabFolder, int tabIndex) {
        TabItem tbtmProcessControl = new TabItem(tabFolder, 0, tabIndex);
        tbtmProcessControl.setText("Process Control");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tabFolder, 512);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        tbtmProcessControl.setControl((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 4);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 2, true, false));
        scrolledComposite.setContent((Control)composite);
        this.createHeader(composite);
        this.createActions(composite);
        this.createVPMTable(composite);
        this.createSnapshot(composite);
    }

    private void createVPMTable(Composite composite) {
        final Group vpmGroup = new Group(composite, 4);
        vpmGroup.setText("Variation Point Models");
        vpmGroup.setLayout((Layout)new GridLayout(1, false));
        vpmGroup.setLayoutData((Object)new GridData(768));
        final Table table = new Table((Composite)vpmGroup, 2560);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        this.reverseButtons = new HashMap<Object, Button>();
        vpmGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = vpmGroup.getClientArea();
                Point oldSize = table.getSize();
                int buttonPrefferedWidth = -1;
                if (ProcessControlTab.this.reverseButtons != null && ProcessControlTab.this.reverseButtons.values().toArray().length > 0) {
                    buttonPrefferedWidth = ((Button)((ProcessControlTab)ProcessControlTab.this).reverseButtons.values().toArray()[0]).computeSize((int)-1, (int)-1).x;
                }
                if (oldSize.x > area.width) {
                    this.setColumnSize(buttonPrefferedWidth);
                    table.setSize(area.width, area.height);
                } else {
                    table.setSize(area.width, area.height);
                    this.setColumnSize(buttonPrefferedWidth);
                }
            }

            private void setColumnSize(int buttonPrefferedWidth) {
                table.getColumns()[0].pack();
                table.getColumns()[1].pack();
                if (buttonPrefferedWidth < 0) {
                    table.getColumns()[2].pack();
                } else {
                    table.getColumns()[2].setWidth(buttonPrefferedWidth);
                }
            }
        });
        this.createTable(table);
    }

    private void createTable(Table exampleTable) {
        this.tableViewer = new TableViewer(exampleTable);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(768));
        TableViewerColumn vpmColumn = new TableViewerColumn(this.tableViewer, 0);
        vpmColumn.getColumn().setText("VPM");
        vpmColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof VPMModelReference)) {
                    return "";
                }
                VPMModelReference vpm = (VPMModelReference)element;
                return FilenameUtils.getBaseName((String)vpm.getPath());
            }
        });
        TableViewerColumn dateColumn = new TableViewerColumn(this.tableViewer, 0);
        dateColumn.getColumn().setText("Date");
        dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof VPMModelReference)) {
                    return "";
                }
                VPMModelReference vpm = (VPMModelReference)element;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IResource resource = root.findMember(vpm.getPath());
                File file = new File(resource.getLocationURI());
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
                return dateFormat.format(file.lastModified());
            }
        });
        TableViewerColumn actionColumn = new TableViewerColumn(this.tableViewer, 0);
        actionColumn.getColumn().setText("Action");
        actionColumn.setLabelProvider((CellLabelProvider)new CellButtonLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.vpmInput = this.getSPLevoProject().getVpmModelReferences();
        this.tableViewer.setInput(this.vpmInput);
    }

    private void createSnapshot(Composite composite) {
        Group snapGroup = new Group(composite, 4);
        snapGroup.setText("Create Variation Point Model Snapshot");
        snapGroup.setLayout((Layout)new GridLayout(3, false));
        snapGroup.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label((Composite)snapGroup, 0);
        nameLabel.setText("Name");
        final Text nameText = new Text((Composite)snapGroup, 2048);
        nameText.setLayoutData((Object)new GridData(768));
        final Button nameButton = new Button((Composite)snapGroup, 0);
        nameButton.setText("Create");
        nameButton.setEnabled(false);
        nameButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                SPLevoBlackBoard spLevoBlackBoard = new SPLevoBlackBoard();
                String splPath = String.valueOf(ProcessControlTab.this.getSPLevoProject().getWorkspace()) + "RefactoredSPL";
                BuildSPLWorkflowConfiguration configuration = new BuildSPLWorkflowConfiguration(splPath);
                configuration.setSplevoProjectEditor(ProcessControlTab.this.getSplevoProjectEditor());
                String name = nameText.getText().trim();
                SnapshotSPLWorkflowDelegate buildSPLWorkflowConfiguration = null;
                try {
                    buildSPLWorkflowConfiguration = new SnapshotSPLWorkflowDelegate(configuration, spLevoBlackBoard, name);
                    WorkflowListenerUtil.runWorkflowAndUpdateUI(buildSPLWorkflowConfiguration, "Save VPM", ProcessControlTab.this.getSplevoProjectEditor());
                    nameText.setText("");
                }
                catch (JobFailedException e1) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (nameText.getText().trim().equals("")) {
                    nameButton.setEnabled(false);
                } else {
                    nameButton.setEnabled(true);
                }
            }
        });
    }

    public void refreshViewer() {
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
            this.tableViewer.getControl().getParent().layout();
            this.tableViewer.getControl().getParent().getParent().layout();
        }
    }

    private void createActions(Composite composite) {
        Group g = new Group(composite, 4);
        g.setText("Actions");
        g.setLayout((Layout)new GridLayout(9, false));
        g.setLayoutData((Object)new GridData(768));
        Composite filler1 = new Composite((Composite)g, 0);
        GridData layoutData = new GridData(0x1000000, 0x1000000, false, false, 4, 1);
        layoutData.heightHint = 0;
        filler1.setLayoutData((Object)layoutData);
        Image circleImage = ResourceManager.getPluginImage("org.splevo.ui", "icons/arrow_circle.png");
        Label circleLbl = new Label((Composite)g, 0);
        circleLbl.setImage(circleImage);
        circleLbl.setLayoutData((Object)new GridData(0x1000000, 1024, false, false));
        Composite filler2 = new Composite((Composite)g, 0);
        filler2.setLayoutData((Object)layoutData);
        Label activityStart = new Label((Composite)g, 0);
        activityStart.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/bullet_green.png"));
        this.addActivityFlowButton((Composite)g);
        this.initVpmBtn = new Button((Composite)g, 64);
        this.initVpmBtn.addMouseListener((MouseListener)new InitVPMListener(this.getSplevoProjectEditor()));
        this.initVpmBtn.setText("Init\nVPM");
        this.initVpmBtn.setToolTipText("Your product copies will be analyzed for differences between them and a variation point model (VPM) will be opened.");
        this.getGridDataForButtons(this.initVpmBtn);
        this.addActivityFlowButton((Composite)g);
        this.analyzeVPMBtn = new Button((Composite)g, 64);
        this.analyzeVPMBtn.addMouseListener((MouseListener)new VPMAnalysisListener(this.getSplevoProjectEditor()));
        this.analyzeVPMBtn.setText("Refine\nVPM");
        this.analyzeVPMBtn.setToolTipText("Analyze the identified variation points (differences) for any relationships between them.");
        this.getGridDataForButtons(this.analyzeVPMBtn);
        this.addActivityFlowButton((Composite)g);
        this.startRefactoringBtn = new Button((Composite)g, 64);
        this.startRefactoringBtn.addMouseListener((MouseListener)new StartRefactoringListener(this.getSplevoProjectEditor()));
        this.startRefactoringBtn.setText("Refactor\nCopies");
        this.startRefactoringBtn.setToolTipText("Integrate the changes identified by variation points into the leading projects.");
        this.getGridDataForButtons(this.startRefactoringBtn);
        this.addActivityFlowButton((Composite)g);
        this.generateFMBtn = new Button((Composite)g, 64);
        this.generateFMBtn.addMouseListener((MouseListener)new GenerateFeatureModelListener(this.getSplevoProjectEditor()));
        this.generateFMBtn.setText("Export\nSPL");
        this.generateFMBtn.setToolTipText("At any time, the designed software product line can be exportet to the format specified in the Configuration section of the dashboard.");
        this.getGridDataForButtons(this.generateFMBtn);
        Composite filler3 = new Composite((Composite)g, 0);
        filler3.setLayoutData((Object)layoutData);
        this.openVPMBtn = new Button((Composite)g, 0);
        this.openVPMBtn.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/splevo.gif"));
        this.openVPMBtn.addMouseListener((MouseListener)new OpenVPMListener(this.getSplevoProjectEditor()));
        this.openVPMBtn.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        this.openVPMBtn.setAlignment(0x1000000);
    }

    private void getGridDataForButtons(Button button) {
        GridData gridData = new GridData();
        gridData.widthHint = button.computeSize((int)-1, (int)-1).x;
        button.setLayoutData((Object)gridData);
    }

    private void addActivityFlowButton(Composite container) {
        Label iconLabel = new Label(container, 0);
        iconLabel.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/arrow_right.png"));
        iconLabel.setAlignment(0x1000000);
    }

    public void enableButtonsIfInformationAvailable() {
        this.disableAllButtonsExceptProjectSelection();
        if (!this.projectsSelected()) {
            return;
        }
        this.initVpmBtn.setEnabled(true);
        if (!this.vpmAvailable()) {
            return;
        }
        this.openVPMBtn.setEnabled(true);
        this.analyzeVPMBtn.setEnabled(true);
        this.startRefactoringBtn.setEnabled(true);
        this.generateFMBtn.setEnabled(true);
    }

    private boolean vpmAvailable() {
        SPLevoProject splevoProject = this.getSPLevoProject();
        if (splevoProject.getVpmModelReferences().size() > 0) {
            String vpmPath = WorkspaceUtil.getAbsoluteFromWorkspaceRelativePath((String)((VPMModelReference)Iterables.getLast((Iterable)splevoProject.getVpmModelReferences())).getPath());
            return new File(vpmPath).canRead();
        }
        return false;
    }

    private boolean projectsSelected() {
        SPLevoProject splevoProject = this.getSPLevoProject();
        return splevoProject.getLeadingProjects().size() > 0 && splevoProject.getIntegrationProjects().size() > 0;
    }

    private void disableAllButtonsExceptProjectSelection() {
        ArrayList<Button> buttons = new ArrayList<Button>();
        buttons.add(this.generateFMBtn);
        buttons.add(this.initVpmBtn);
        buttons.add(this.analyzeVPMBtn);
        buttons.add(this.startRefactoringBtn);
        buttons.add(this.openVPMBtn);
        for (Control control : buttons) {
            control.setEnabled(false);
        }
    }

    private void createHeader(Composite composite) {
        Header header = new Header(composite, 0);
        header.setTitle("SPLevo Dashboard");
        header.setImage(ResourceManager.getPluginImage("org.splevo.ui", "icons/kopl_dash.png"));
        header.setDescription("Control the consolidation process.");
        header.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private class CellButtonLabelProvider
    extends CellLabelProvider {
        private static final String VPM_DATA = "vpm_data";
        private static final String BUTTON_EDITOR = "button_editor";

        private CellButtonLabelProvider() {
        }

        public void update(final ViewerCell cell) {
            Button button;
            TableItem item = (TableItem)cell.getItem();
            if (ProcessControlTab.this.reverseButtons.containsKey(cell.getElement())) {
                button = (Button)ProcessControlTab.this.reverseButtons.get(cell.getElement());
            } else {
                button = new Button((Composite)cell.getViewerRow().getControl(), 0);
                button.setData(VPM_DATA, item.getData());
                button.setText("Revert to this version");
                button.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent event) {
                        Shell shell = event.widget.getDisplay().getActiveShell();
                        if (!(event.getSource() instanceof Button)) {
                            return;
                        }
                        Button button = (Button)event.getSource();
                        if (!(button.getData(CellButtonLabelProvider.VPM_DATA) instanceof VPMModelReference)) {
                            return;
                        }
                        VPMModelReference vpm = (VPMModelReference)button.getData(CellButtonLabelProvider.VPM_DATA);
                        boolean confirmed = MessageDialog.openQuestion((Shell)shell, (String)"Switch Back VPM Version", (String)String.format("You want to switch back to %s, which removes all later versions. Do you want to continue?", FilenameUtils.getBaseName((String)vpm.getPath())));
                        if (confirmed) {
                            try {
                                VPMUIUtil.switchBackVPMVersion((SPLevoProject)ProcessControlTab.this.getSPLevoProject(), (VPMModelReference)vpm).join();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ProcessControlTab.this.tableViewer.setInput((Object)ProcessControlTab.this.vpmInput);
                            ProcessControlTab.this.tableViewer.refresh();
                            this.disposeButtons();
                        }
                    }

                    private void disposeButtons() {
                        for (Button button : ProcessControlTab.this.reverseButtons.values()) {
                            if (button.isDisposed()) continue;
                            Object o = button.getData(CellButtonLabelProvider.VPM_DATA);
                            if (ProcessControlTab.this.vpmInput.contains(o)) continue;
                            TableEditor e = (TableEditor)button.getData(CellButtonLabelProvider.BUTTON_EDITOR);
                            e.getEditor().dispose();
                            e.dispose();
                            ProcessControlTab.this.reverseButtons.remove(cell.getElement());
                        }
                    }

                    public void mouseDown(MouseEvent e) {
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
                ProcessControlTab.this.reverseButtons.put(cell.getElement(), button);
            }
            TableEditor editor = new TableEditor(item.getParent());
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setEditor((Control)button, item, cell.getColumnIndex());
            button.setData(BUTTON_EDITOR, (Object)editor);
            editor.layout();
        }
    }
}

