/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.splevo.extraction.DefaultExtractionService;
import org.splevo.extraction.SoftwareModelExtractionException;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.commons.util.JobUtil;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.jobs.ProjectPathUtil;
import org.splevo.ui.jobs.SPLevoBlackBoard;

public class ExtractionJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private static final int PROGRESS_UPDATE_PROJECT_INFO_DONE = 5;
    private static final int PROGRESS_RESOURCESET_MERGE_DONE = 10;
    private static final int PROGRESS_EXTRACTION_DONE = 100;
    private static final int PROGRESS_PREPARATION_DONE = 10;
    private SPLevoProject splevoProject;
    private boolean processLeading;
    private String extractorId;

    public ExtractionJob(String extractorId, SPLevoProject splevoProject, boolean processLeading) {
        this.splevoProject = splevoProject;
        this.processLeading = processLeading;
        this.extractorId = extractorId;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        EList projectNames = null;
        String variantName = null;
        if (this.processLeading) {
            projectNames = this.splevoProject.getLeadingProjects();
            variantName = this.splevoProject.getVariantNameLeading();
        } else {
            projectNames = this.splevoProject.getIntegrationProjects();
            variantName = this.splevoProject.getVariantNameIntegration();
        }
        this.logger.info((Object)String.format("Extraction of %s started at %s", variantName, JobUtil.getTimestamp()));
        String sourceModelPath = WorkspaceUtil.getSourceModelPathWithinEclipse((SPLevoProject)this.splevoProject, (String)variantName);
        List<String> projectURIsAbsolute = ProjectPathUtil.buildProjectPaths((List<String>)projectNames);
        if (monitor.isCanceled()) {
            monitor.done();
            return;
        }
        DefaultExtractionService extractionService = new DefaultExtractionService();
        monitor.worked(10);
        try {
            monitor.subTask("Extract Model for project: " + variantName);
            ResourceSet resourceSet = extractionService.extractSoftwareModel(this.extractorId, projectURIsAbsolute, monitor, sourceModelPath);
            monitor.worked(100);
            if (this.processLeading) {
                ((SPLevoBlackBoard)this.getBlackboard()).getResourceSetLeading().getResources().addAll((Collection)resourceSet.getResources());
            } else {
                ((SPLevoBlackBoard)this.getBlackboard()).getResourceSetIntegration().getResources().addAll((Collection)resourceSet.getResources());
            }
            monitor.worked(10);
        }
        catch (SoftwareModelExtractionException e) {
            throw new JobFailedException("Failed to extract model.", (Throwable)e);
        }
        monitor.subTask("Update SPLevo project information");
        if (this.processLeading) {
            this.splevoProject.setSourceModelPathLeading(sourceModelPath);
        } else {
            this.splevoProject.setSourceModelPathIntegration(sourceModelPath);
        }
        monitor.worked(5);
        if (monitor.isCanceled()) {
            monitor.done();
            return;
        }
        this.logger.info((Object)String.format("Extraction of %s finished at %s", variantName, JobUtil.getTimestamp()));
    }

    public String getName() {
        if (this.processLeading) {
            return "Model Extraction Job " + this.splevoProject.getVariantNameLeading();
        }
        return "Model Extraction Job " + this.splevoProject.getVariantNameIntegration();
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }
}

