/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.graphstream.algorithm.ConnectedComponents;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMAnalyzerService;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class MergeVPMAnalyzerResultsIntoGraphJob
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private VPMAnalyzerService analyzerService = new DefaultVPMAnalyzerService();

    public void execute(IProgressMonitor monitor) {
        this.logger.info((Object)"Load VPM Graph");
        VPMGraph vpmGraph = ((SPLevoBlackBoard)this.getBlackboard()).getVpmGraph();
        this.logger.info((Object)"Load VPM analyzer results");
        List<VPMAnalyzerResult> analyzerResults = ((SPLevoBlackBoard)this.getBlackboard()).getVpmAnalyzerResults();
        this.logger.info((Object)"Merge analyzer results into graph.");
        if (analyzerResults.size() == 0) {
            this.logger.warn((Object)"No VPMAnalyzer results found in the blackboard");
        }
        this.analyzerService.createGraphEdges(vpmGraph, analyzerResults);
        this.logStatistics(vpmGraph);
        monitor.done();
    }

    private void logStatistics(VPMGraph vpmGraph) {
        ConnectedComponents cc = new ConnectedComponents();
        cc.init((Graph)vpmGraph);
        int nodeCount = vpmGraph.getNodeCount();
        int edgeCount = vpmGraph.getEdgeCount();
        String clusterDegrees = this.getClusterDegrees(cc, nodeCount);
        String nodeDegrees = this.getNodeDegrees(vpmGraph);
        this.logger.info((Object)("VPM Analysis Result: #Nodes: " + nodeCount));
        this.logger.info((Object)("VPM Analysis Result: #Edges: " + edgeCount));
        this.logger.info((Object)("VPM Analysis Result: #Subgraphs: " + cc.getConnectedComponentsCount()));
        this.logger.info((Object)("VPM Analysis Result: #SingleNodes: " + cc.getConnectedComponentsCount(1, 2)));
        this.logger.info((Object)("VPM Analysis Result: Node Degrees (#EdgesPerNode:#Instances): [" + nodeDegrees + "]"));
        this.logger.info((Object)("VPM Analysis Result: Cluster Degrees (NodesPerSubgraph:#Instances): [" + clusterDegrees + "]"));
    }

    private String getNodeDegrees(VPMGraph vpmGraph) {
        LinkedHashMultimap degreeStatistics = LinkedHashMultimap.create();
        for (Node node : vpmGraph.getNodeSet()) {
            degreeStatistics.get((Object)node.getDegree()).add(node);
        }
        StringBuilder degreePrint = new StringBuilder();
        LinkedList degrees = Lists.newLinkedList((Iterable)degreeStatistics.keySet());
        Collections.sort(degrees);
        for (Integer degree : degrees) {
            if (degreePrint.length() > 0) {
                degreePrint.append("|");
            }
            degreePrint.append(degree + ":" + degreeStatistics.get((Object)degree).size());
        }
        return degreePrint.toString();
    }

    private String getClusterDegrees(ConnectedComponents cc, int maxDegree) {
        LinkedHashMap degreeStatistics = Maps.newLinkedHashMap();
        int degree = 1;
        while (degree <= maxDegree) {
            int degreeCount = cc.getConnectedComponentsCount(degree, degree + 1);
            if (degreeCount != 0) {
                degreeStatistics.put(degree, degreeCount);
            }
            ++degree;
        }
        StringBuilder degreePrint = new StringBuilder();
        for (Integer degree2 : degreeStatistics.keySet()) {
            if (degreePrint.length() > 0) {
                degreePrint.append("|");
            }
            degreePrint.append(degree2 + ":" + degreeStatistics.get(degree2));
        }
        return degreePrint.toString();
    }

    public String getName() {
        return "Merge VPMGraph Job";
    }

    public void cleanup(IProgressMonitor arg0) {
    }
}

