/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.jobs.SPLevoBlackBoard;

public class RefreshLeadingCopyProjects
extends AbstractBlackboardInteractingJob<SPLevoBlackBoard> {
    private static final Logger LOGGER = Logger.getLogger(RefreshLeadingCopyProjects.class);
    private final SPLevoProject splevoProject;

    public RefreshLeadingCopyProjects(SPLevoProject splevoProject) {
        this.splevoProject = splevoProject;
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        monitor.beginTask("Refreshing", this.splevoProject.getLeadingProjects().size());
        for (String leadingProjectName : this.splevoProject.getLeadingProjects()) {
            IProject leadingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(leadingProjectName);
            if (leadingProject == null) {
                LOGGER.warn((Object)("Could not refresh leading project " + leadingProjectName + " because we could not find it in the workspace."));
            } else {
                try {
                    leadingProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    throw new JobFailedException(e);
                }
            }
            monitor.worked(1);
        }
        try {
            IJobManager jobManager = Job.getJobManager();
            jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
            jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)"Refreshing might not be finished, but we received an interrupt.", (Throwable)e);
        }
        monitor.done();
    }

    public String getName() {
        return "Refresh leading copy projects job.";
    }
}

