/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.jobs;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.project.SPLevoProject;
import org.splevo.refactoring.VariabilityRefactoringFailedException;
import org.splevo.refactoring.VariabilityRefactoringService;
import org.splevo.ui.jobs.RefactorVPMJob;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class SemiAutomatedRefactorVPMJob
extends RefactorVPMJob {
    private final String variationPointId;
    private final SPLevoProject splevoProject;

    public SemiAutomatedRefactorVPMJob(SPLevoProject splevoProject, String variationPointId) {
        super(splevoProject);
        this.variationPointId = variationPointId;
        this.splevoProject = splevoProject;
    }

    @Override
    public void execute(IProgressMonitor arg0) throws JobFailedException, UserCanceledException {
        VariationPointModel vpm = ((SPLevoBlackBoard)this.getBlackboard()).getVariationPointModel();
        Optional<VariationPoint> vp = this.findVPToBeRefactored(vpm);
        if (!vp.isPresent()) {
            throw new JobFailedException("The VP that shall be refactored could not be found in the VPM.");
        }
        String leadingSrcPath = new File(this.getLeadingSrcPath()).getAbsolutePath();
        HashMap refactoringConfigurations = Maps.newHashMap();
        refactoringConfigurations.put("JaMoPP.Refactoring.Options.SourceDirectory", leadingSrcPath);
        refactoringConfigurations.put("SPLEVO_PROJECT", this.splevoProject);
        VariabilityRefactoringService variabilityRefactoringService = new VariabilityRefactoringService();
        try {
            variabilityRefactoringService.refactorSemiAutomated(vpm, (VariationPoint)vp.get(), (Map)refactoringConfigurations);
        }
        catch (VariabilityRefactoringFailedException e) {
            throw new JobFailedException("The refactoring failed during execution.", (Throwable)e);
        }
    }

    private Optional<VariationPoint> findVPToBeRefactored(VariationPointModel vpm) {
        Iterable vps = Iterables.concat((Iterable)Iterables.transform((Iterable)vpm.getVariationPointGroups(), (Function)new Function<VariationPointGroup, Iterable<VariationPoint>>(){

            public Iterable<VariationPoint> apply(VariationPointGroup input) {
                return input.getVariationPoints();
            }
        }));
        return Iterables.tryFind((Iterable)vps, (Predicate)new Predicate<VariationPoint>(){

            public boolean apply(VariationPoint input) {
                return input.getId().equals(SemiAutomatedRefactorVPMJob.this.variationPointId);
            }
        });
    }

    @Override
    public String getName() {
        return "Semi-automated VPM refactoring job";
    }
}

