/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.listeners;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.vpexplorer.util.VPMUIUtil;

public class OpenVPMListener
extends MouseAdapter {
    private Logger logger = Logger.getLogger(OpenVPMListener.class);
    private SPLevoProjectEditor splevoProjectEditor = null;

    public OpenVPMListener(SPLevoProjectEditor splevoProjectEditor) {
        this.splevoProjectEditor = splevoProjectEditor;
    }

    public void mouseUp(MouseEvent e) {
        SPLevoProject splevoProject = this.splevoProjectEditor.getSplevoProject();
        EList vpmModelReferences = splevoProject.getVpmModelReferences();
        if (vpmModelReferences.size() == 0) {
            Shell shell = Display.getDefault().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)"No VPM to open", (String)"There is Variation Point Model to be opened");
            this.logger.error((Object)"Tried to open VPM from a SPLevoProject that does not contain any");
            return;
        }
        VPMModelReference vpmModelReference = (VPMModelReference)vpmModelReferences.get(vpmModelReferences.size() - 1);
        VPMUIUtil.openVPExplorer((SPLevoProject)splevoProject, (VPMModelReference)vpmModelReference);
    }
}

