/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.nature;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.splevo.project.SPLevoProject;
import org.splevo.project.utils.SPLevoProjectUtil;

public class SPLevoBuilder
extends IncrementalProjectBuilder {
    private Logger logger = Logger.getLogger(SPLevoBuilder.class);
    public static final String BUILDER_ID = "org.splevo.ui.splevobuilder";
    private static final String MARKER_TYPE = "org.splevo.ui.splevoConfigurationProblem";

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException e) {
            this.logger.warn((Object)"Failed to add a marker.", (Throwable)e);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    private void checkProjectSettings(IResource resource) {
        if (resource instanceof IFile && resource.getName().endsWith("splevoproject")) {
            IFile file = (IFile)resource;
            this.deleteMarkers(file);
            SPLevoProject splEvoProject = null;
            try {
                try {
                    splEvoProject = SPLevoProjectUtil.loadSPLevoProjectModel((File)new File(resource.getFullPath().toString()));
                }
                catch (IOException e) {
                    this.logger.warn((Object)"Failed to check project settings.", (Throwable)e);
                    if (splEvoProject == null) {
                        this.addMarker(file, "Project configuration file could not be loaded", -1, 2);
                    }
                }
            }
            finally {
                if (splEvoProject == null) {
                    this.addMarker(file, "Project configuration file could not be loaded", -1, 2);
                }
            }
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException ce) {
            this.logger.warn((Object)"Builder failed to delete a marker.", (Throwable)ce);
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new SPLevoProjectFileResourceVisitor());
        }
        catch (CoreException e) {
            this.logger.warn((Object)"Builder failed to perform a full build.", (Throwable)e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new SPLevoProjectFileDeltaVisitor());
    }

    class SPLevoProjectFileDeltaVisitor
    implements IResourceDeltaVisitor {
        SPLevoProjectFileDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    SPLevoBuilder.this.checkProjectSettings(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    SPLevoBuilder.this.checkProjectSettings(resource);
                    break;
                }
            }
            return true;
        }
    }

    class SPLevoProjectFileResourceVisitor
    implements IResourceVisitor {
        SPLevoProjectFileResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            SPLevoBuilder.this.checkProjectSettings(resource);
            return true;
        }
    }
}

