/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.software.SourceLocation;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public class ArgoUMLVariantScanHandler
extends AbstractHandler {
    private static final String MARKER = "//@#$LPS-";
    private static final int MARKER_LENGTH = "//@#$LPS-".length();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection curSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if ((curSelection = this.convertTreeSelection(curSelection)) instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)curSelection;
            ArrayList vps = Lists.newArrayList();
            for (Object selectedItem : selection.toList()) {
                if (selectedItem instanceof VariationPoint) {
                    vps.add((VariationPoint)selectedItem);
                    continue;
                }
                if (!(selectedItem instanceof Refinement)) continue;
                vps.addAll(((Refinement)selectedItem).getVariationPoints());
            }
            this.scanForIncludedFeatures(vps);
        }
        return null;
    }

    private ISelection convertTreeSelection(ISelection curSelection) {
        if (curSelection instanceof TreeSelection && ((TreeSelection)curSelection).isEmpty()) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            ISelectionService selectionService = win.getSelectionService();
            curSelection = selectionService.getSelection();
        }
        return curSelection;
    }

    private void scanForIncludedFeatures(List<VariationPoint> vps) {
        HashMultiset identifiedFeatues = HashMultiset.create();
        ArrayList errors = Lists.newArrayList();
        for (VariationPoint vp : vps) {
            Set<SoftwareElement> elements = this.getNotLeadingImplementingElements(vp);
            if (elements.size() == 0) {
                identifiedFeatues.add((Object)"{NONE}");
            }
            for (SoftwareElement element : elements) {
                SourceLocation sourceLocation = element.getSourceLocation();
                String path = sourceLocation.getFilePath();
                List lines = null;
                try {
                    lines = FileUtils.readLines((File)new File(path));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                int markerLineIndex = this.getMarkerLineIndex(vp, sourceLocation, lines);
                if (markerLineIndex == -1) {
                    errors.add("No marker found for " + path.substring(path.length() - 20));
                    continue;
                }
                String featureId = this.getFeatureId(lines, markerLineIndex);
                if (this.isMarkerLine(lines, markerLineIndex - 1)) {
                    featureId = String.valueOf(this.getFeatureId(lines, markerLineIndex - 1)) + " + " + featureId;
                } else if (this.isMarkerLine(lines, markerLineIndex + 1)) {
                    featureId = String.valueOf(featureId) + " + " + this.getFeatureId(lines, markerLineIndex + 1);
                }
                identifiedFeatues.add((Object)featureId);
            }
        }
        if (errors.size() > 0) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Marker Detection Errors", (String)Joiner.on((String)"\n").join((Iterable)errors));
        }
        StringBuilder message = new StringBuilder();
        message.append("VP Count Total: ");
        message.append(vps.size());
        for (String featureId : identifiedFeatues.elementSet()) {
            message.append("\n");
            message.append(identifiedFeatues.count((Object)featureId));
            message.append(" x ");
            message.append(featureId);
        }
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)message.toString());
    }

    private String getFeatureId(List<String> lines, int lineIndex) {
        String line = lines.get(lineIndex).trim();
        return line.substring(MARKER_LENGTH, line.indexOf(":", MARKER_LENGTH));
    }

    private int getMarkerLineIndex(VariationPoint vp, SourceLocation sourceLocation, List<String> lines) {
        int elementIdentation = this.getIdentation(lines, sourceLocation.getStartLine() - 1);
        int markerLineIndex = -1;
        if (vp.getVariants().size() == 1) {
            int lineIndex = sourceLocation.getStartLine();
            while (lineIndex >= 0) {
                if (this.isMarkerLine(lines, lineIndex) && this.getIdentation(lines, lineIndex) == elementIdentation) {
                    markerLineIndex = lineIndex;
                    break;
                }
                --lineIndex;
            }
        } else {
            int lineIndex = sourceLocation.getStartLine();
            while (lineIndex < lines.size()) {
                if (this.isMarkerLine(lines, lineIndex)) {
                    markerLineIndex = lineIndex;
                    break;
                }
                ++lineIndex;
            }
        }
        return markerLineIndex;
    }

    private int getIdentation(List<String> lines, int index) {
        String line = lines.get(index);
        int identation = line.length() - line.replaceFirst("^\\s*", "").length();
        return identation;
    }

    private boolean isMarkerLine(List<String> lines, int lineIndex) {
        return lines.get(lineIndex).trim().matches("//@#\\$LPS-.*:GranularityType:.*");
    }

    private Set<SoftwareElement> getNotLeadingImplementingElements(VariationPoint vp) {
        LinkedHashSet elements = Sets.newLinkedHashSet();
        for (Variant v : vp.getVariants()) {
            if (v.getLeading().booleanValue()) continue;
            EList implementingElements = v.getImplementingElements();
            elements.addAll(implementingElements);
        }
        return elements;
    }
}

