/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.wb.swt.SWTResourceManager;
import org.splevo.ui.SPLevoUIPlugin;
import org.splevo.ui.commons.tooltip.CustomizableDescriptionHavingTreeViewerToolTip;
import org.splevo.ui.editors.SPLevoProjectEditor;
import org.splevo.ui.refinementbrowser.RefinementDetailsView;
import org.splevo.ui.refinementbrowser.RefinementTreeContentProvider;
import org.splevo.ui.refinementbrowser.RefinementTreeLabelProvider;
import org.splevo.ui.refinementbrowser.VPMRefinementBrowserInput;
import org.splevo.ui.refinementbrowser.action.ApplyRefinementsAction;
import org.splevo.ui.refinementbrowser.action.ApplySelectedRefinementsAction;
import org.splevo.ui.refinementbrowser.action.CancelAction;
import org.splevo.ui.refinementbrowser.action.DeleteRefinementAction;
import org.splevo.ui.refinementbrowser.action.RefinementEditDescriptionAction;
import org.splevo.ui.refinementbrowser.action.RenameRefinementAction;
import org.splevo.ui.refinementbrowser.action.ToggleVisualizationAction;
import org.splevo.ui.refinementbrowser.listener.CommandActionMenuListener;
import org.splevo.ui.refinementbrowser.listener.ExpandTreeListener;
import org.splevo.ui.refinementbrowser.listener.RefinementActionBarListener;
import org.splevo.ui.refinementbrowser.listener.RefinementInfoSelectionListener;
import org.splevo.ui.refinementbrowser.listener.RefinementSelectionListener;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementModel;

public class VPMRefinementBrowser
extends EditorPart {
    public static final String ID = "org.splevo.ui.editor.VPMRefinementEditor";
    private VPMRefinementBrowserInput input;
    private TreeViewer refinementListView;
    private FormToolkit toolkit;
    private Form form;
    private RefinementDetailsView detailsView;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof VPMRefinementBrowserInput)) {
            throw new RuntimeException("Wrong input");
        }
        this.input = (VPMRefinementBrowserInput)editorInput;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setPartName("VPM Refinement Browser");
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.form.setText("SPLevo Refinement Browser");
        this.toolkit.decorateFormHeading(this.form);
        this.form.getMenuManager().add((IAction)new ApplyRefinementsAction(this, "Apply Refinements"));
        this.form.getMenuManager().add((IAction)new ApplySelectedRefinementsAction(this, "Apply Selected Refinements"));
        this.form.getBody().setLayout((Layout)new FillLayout(256));
        SashForm sashForm = new SashForm(this.form.getBody(), 4);
        sashForm.setSashWidth(1);
        sashForm.setBackground(SWTResourceManager.getColor(15));
        this.toolkit.adapt((Composite)sashForm);
        this.toolkit.paintBordersFor((Composite)sashForm);
        this.createRefinementListView(sashForm);
        this.createRefinementDetails(sashForm);
        this.refinementListView.addSelectionChangedListener((ISelectionChangedListener)new RefinementSelectionListener(this.detailsView));
        this.refinementListView.addSelectionChangedListener((ISelectionChangedListener)new RefinementInfoSelectionListener(this.detailsView));
        IActionBars actionBars = this.getEditorSite().getActionBars();
        this.refinementListView.addSelectionChangedListener((ISelectionChangedListener)new RefinementActionBarListener(actionBars));
        sashForm.setWeights(new int[]{2, 8});
        ToolBarManager manager = (ToolBarManager)this.form.getToolBarManager();
        manager.add((IAction)new ApplyRefinementsAction(this, "Apply Refinements"));
        manager.add((IAction)new ApplySelectedRefinementsAction(this, "Apply Selected Refinements"));
        manager.add((IAction)new ToggleVisualizationAction(this, this.getEnableVisualizationDefault()));
        manager.add((IAction)new CancelAction(this, "Cancel and close"));
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)manager, "popup:formsToolBar");
        manager.update(true);
        this.initContextMenu();
        this.initToolTips(this.refinementListView);
    }

    private void createRefinementDetails(SashForm sashForm) {
        this.detailsView = new RefinementDetailsView(sashForm, this.getSite());
    }

    private void createRefinementListView(SashForm sashForm) {
        this.refinementListView = new TreeViewer((Composite)sashForm, 2818);
        this.refinementListView.setContentProvider((IContentProvider)new RefinementTreeContentProvider());
        this.refinementListView.setLabelProvider((IBaseLabelProvider)new RefinementTreeLabelProvider());
        this.refinementListView.setAutoExpandLevel(2);
        this.refinementListView.setInput((Object)this.input.getRefinementModel());
        this.refinementListView.addDoubleClickListener((IDoubleClickListener)new ExpandTreeListener());
    }

    public RefinementModel getRefinementModel() {
        return this.input.getRefinementModel();
    }

    public List<Refinement> getSelectedRefinementsFromMainView() {
        ArrayList<Refinement> selectedRefinements = new ArrayList<Refinement>();
        ISelection listViewSelection = this.refinementListView.getSelection();
        if (!(listViewSelection instanceof IStructuredSelection)) {
            return selectedRefinements;
        }
        IStructuredSelection refinementListViewSelection = (IStructuredSelection)listViewSelection;
        for (Object selectedObject : refinementListViewSelection) {
            if (!(selectedObject instanceof Refinement)) continue;
            selectedRefinements.add((Refinement)selectedObject);
        }
        return selectedRefinements;
    }

    public SPLevoProjectEditor getSPLevoProjectEditor() {
        return this.input.getSplevoEditor();
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager();
        final VPMRefinementBrowser browser = this;
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new DeleteRefinementAction(VPMRefinementBrowser.this.refinementListView, VPMRefinementBrowser.this.detailsView);
                manager.add((IAction)action);
                action = new RenameRefinementAction(VPMRefinementBrowser.this.refinementListView);
                manager.add((IAction)action);
                action = new RefinementEditDescriptionAction(VPMRefinementBrowser.this.refinementListView);
                manager.add((IAction)action);
                action = new ApplySelectedRefinementsAction(browser, "Apply Selected Refinements");
                manager.add((IAction)action);
            }
        });
        menuMgr.addMenuListener((IMenuListener)new CommandActionMenuListener("org.splevo.ui.commands.argouml.variantscan", SPLevoUIPlugin.getImageDescriptor("icons/kopl_circle_only.png")));
        Menu menu = menuMgr.createContextMenu((Control)this.refinementListView.getTree());
        this.refinementListView.getTree().setMenu(menu);
    }

    private void initToolTips(TreeViewer viewer) {
        new CustomizableDescriptionHavingTreeViewerToolTip(viewer);
    }

    public Image getTitleImage() {
        return SPLevoUIPlugin.getImageDescriptor("icons/refinement-browser.gif").createImage();
    }

    public void setEnableVisualization(boolean enabled) {
        this.detailsView.setEnableVisualization(enabled);
    }

    private boolean getEnableVisualizationDefault() {
        return this.detailsView.getEnableVisualizationDefault();
    }
}

