/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser.listener;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementType;

public class RefinementActionBarListener
implements ISelectionChangedListener {
    private IActionBars actionBars = null;

    public RefinementActionBarListener(IActionBars actionBars) {
        this.actionBars = actionBars;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            int groupCount = 0;
            int mergeCount = 0;
            int subMergeCount = 0;
            int vpCount = 0;
            for (Object next : (IStructuredSelection)selection) {
                if (!(next instanceof Refinement)) continue;
                Refinement refinement = (Refinement)next;
                RefinementType type = refinement.getType();
                if (type == RefinementType.GROUPING) {
                    ++groupCount;
                } else if (type == RefinementType.MERGE) {
                    if (refinement.getParent() != null) {
                        ++subMergeCount;
                    } else {
                        ++mergeCount;
                    }
                }
                vpCount += refinement.getVariationPoints().size();
            }
            String messageText = "Groupings: %s, SubMerges: %s | Merges: %s | VPs: %s";
            String message = String.format(messageText, groupCount, subMergeCount, mergeCount, vpCount);
            this.actionBars.getStatusLineManager().setMessage(message);
        }
    }
}

