/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.refinementbrowser.listener;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.splevo.ui.refinementbrowser.RefinementBrowserUtil;
import org.splevo.ui.refinementbrowser.RefinementDetailsView;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementReason;
import org.splevo.vpm.variability.VariationPoint;

public class RefinementInfoSelectionListener
implements ISelectionChangedListener {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String HEADLINE = "Refinement Infos";
    private static final String SUBHEADLINE = "Source: ";
    private RefinementDetailsView refinementDetailView;

    public RefinementInfoSelectionListener(RefinementDetailsView refinementDetailsView) {
        this.refinementDetailView = refinementDetailsView;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selectedElement = ((StructuredSelection)event.getSelection()).getFirstElement();
        String info = null;
        if (selectedElement instanceof Refinement) {
            info = this.getRelationshipSourceInfo((Refinement)selectedElement);
        } else if (selectedElement instanceof VariationPoint) {
            info = this.getRelationshipSourceInfo((VariationPoint)selectedElement, event);
        }
        if (info != null) {
            this.refinementDetailView.displayRefinementInfo(HEADLINE, SUBHEADLINE, info);
        }
    }

    private String getRelationshipSourceInfo(VariationPoint vp, SelectionChangedEvent event) {
        TreeViewer treeViewer = RefinementBrowserUtil.getTreeViewer(event);
        if (treeViewer == null) {
            return null;
        }
        Refinement refinement = RefinementBrowserUtil.getRefinement(treeViewer);
        StringBuilder buffer = new StringBuilder();
        buffer.append(refinement.getSource());
        buffer.append(LINE_SEPARATOR);
        for (RefinementReason reason : refinement.getReasons()) {
            if (!reason.getSource().equals(vp) && !reason.getTarget().equals(vp)) continue;
            buffer.append(LINE_SEPARATOR);
            buffer.append(reason.getReason());
        }
        String text = buffer.toString();
        return text;
    }

    private String getRelationshipSourceInfo(Refinement refinement) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(refinement.getSource());
        buffer.append(LINE_SEPARATOR);
        for (RefinementReason reason : refinement.getReasons()) {
            buffer.append(LINE_SEPARATOR);
            buffer.append(reason.getReason());
        }
        String text = buffer.toString();
        return text;
    }
}

