/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.texteditor.ITextEditor;
import org.splevo.ui.sourceconnection.jdt.JavaEditorConnector;
import org.splevo.vpm.software.JavaSoftwareElement;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.software.SourceLocation;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;

public class SourceEditorConnector {
    private static Logger logger = Logger.getLogger(SourceEditorConnector.class);
    private static JavaEditorConnector javaEditorConnector = new JavaEditorConnector();

    public static void openVariationPoint(VariationPoint variationPoint, List<String> filesOpen) {
        for (Variant variant : variationPoint.getVariants()) {
            SourceEditorConnector.openVariant(variant, filesOpen);
        }
    }

    public static void openVariant(Variant variant, List<String> filesOpen) {
        String message = String.format("Implementation of Variant %s", variant.getId());
        ITextEditor editor = null;
        for (SoftwareElement softwareElement : variant.getImplementingElements()) {
            if (!(softwareElement instanceof JavaSoftwareElement)) continue;
            editor = javaEditorConnector.openEditor((JavaSoftwareElement)softwareElement);
            SourceEditorConnector.prepareEditorIfFileNotOpen(filesOpen, softwareElement, editor);
        }
        if (editor != null) {
            javaEditorConnector.highlightInTextEditor(editor, message, variant);
            javaEditorConnector.setImageIcon(editor, variant);
        }
    }

    private static void prepareEditorIfFileNotOpen(List<String> filesOpen, SoftwareElement softwareElement, ITextEditor editor) {
        String filePath = softwareElement.getSourceLocation().getFilePath();
        if (!filesOpen.contains(filePath)) {
            javaEditorConnector.resetLocationHighlighting(editor);
            filesOpen.add(filePath);
            javaEditorConnector.jumpToLocation(editor, softwareElement.getSourceLocation());
        }
    }

    public static List<String> getCodeForVariant(Variant variant) {
        LinkedList elementCodes = Lists.newLinkedList();
        if (variant != null) {
            for (SoftwareElement e : variant.getImplementingElements()) {
                String code = SourceEditorConnector.appendCodeForSourceLocation(e.getSourceLocation());
                if (code == null) continue;
                elementCodes.add(code);
            }
        }
        return elementCodes;
    }

    private static String appendCodeForSourceLocation(SourceLocation sourceLocation) {
        String code = null;
        IPath location = Path.fromOSString((String)sourceLocation.getFilePath());
        try {
            code = FileUtils.readFileToString((File)location.toFile());
        }
        catch (IOException e) {
            logger.error((Object)"Error while reading source file", (Throwable)e);
            return null;
        }
        return code.substring(sourceLocation.getStartPosition(), sourceLocation.getEndPosition());
    }
}

