/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.project.SPLevoProject;
import org.splevo.project.VPMModelReference;
import org.splevo.ui.sourceconnection.UnifiedDiffFileHandler;
import org.splevo.ui.sourceconnection.helper.FileLineNumberPair;
import org.splevo.ui.sourceconnection.helper.FileWithID;
import org.splevo.ui.sourceconnection.helper.IndexedLineNumber;
import org.splevo.ui.sourceconnection.helper.NumbersTextPair;
import org.splevo.ui.sourceconnection.helper.UnifiedPOI;
import org.splevo.ui.util.CollectionUtil;
import org.splevo.ui.util.UIConstants;
import org.splevo.vpm.VPMUtil;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class UnifiedDiffConnectorModel {
    private static final Logger LOGGER = Logger.getLogger(UnifiedDiffConnectorModel.class);
    private File unifiedDiffFile;
    private String proccessedFileName;
    private List<VariationPoint> variationPoints;
    private Multimap<String, Variant> idToVariants;
    private FileWithID leadingFile;
    private List<FileWithID> integrationCopyList;
    private List<UnifiedPOI> leadingPOIs;
    private List<UnifiedPOI> integrationPOIs;
    private List<NumbersTextPair> unifiedLines;

    public UnifiedDiffConnectorModel(SPLevoProject splevoProject, Set<Variant> variants, File unifiedDiffFile, String fileName) {
        this.unifiedDiffFile = unifiedDiffFile;
        this.proccessedFileName = fileName;
        VariationPointModel vpm = this.getVPM(splevoProject);
        this.variationPoints = this.extractVariationPoints(vpm);
        this.idToVariants = this.createIdToVariantMapping(this.variationPoints);
        this.leadingFile = this.extractLeadingFile();
        this.integrationCopyList = this.extractIntegrationFiles();
        this.leadingPOIs = new ArrayList<UnifiedPOI>();
        this.integrationPOIs = new ArrayList<UnifiedPOI>();
        for (Variant var : variants) {
            IPath path = Path.fromOSString((String)((SoftwareElement)var.getImplementingElements().get(0)).getSourceLocation().getFilePath());
            String filePath = path.toOSString();
            int lineNumber = ((SoftwareElement)var.getImplementingElements().get(0)).getSourceLocation().getStartLine();
            if (var.getLeading().booleanValue()) {
                this.leadingPOIs.add(new UnifiedPOI(filePath, lineNumber));
                continue;
            }
            this.integrationPOIs.add(new UnifiedPOI(filePath, lineNumber));
        }
    }

    private VariationPointModel getVPM(SPLevoProject splevoProject) {
        int lastIndex = splevoProject.getVpmModelReferences().size() - 1;
        File vpmFile = new File(((VPMModelReference)splevoProject.getVpmModelReferences().get(lastIndex)).getPath());
        try {
            return VPMUtil.loadVariationPointModel((File)vpmFile, (ResourceSet)new SPLevoResourceSet());
        }
        catch (IOException e) {
            LOGGER.error((Object)("Could not load variation point model located at \"" + vpmFile.getAbsolutePath() + "\"."), (Throwable)e);
            return null;
        }
    }

    private List<VariationPoint> extractVariationPoints(VariationPointModel vpm) {
        ArrayList<VariationPoint> vps = new ArrayList<VariationPoint>();
        for (VariationPointGroup vpGroup : vpm.getVariationPointGroups()) {
            for (VariationPoint vp : vpGroup.getVariationPoints()) {
                vps.add(vp);
            }
        }
        return vps;
    }

    private Multimap<String, Variant> createIdToVariantMapping(List<VariationPoint> vps) {
        ArrayListMultimap mapping = ArrayListMultimap.create();
        for (VariationPoint vp : vps) {
            for (Variant variant : vp.getVariants()) {
                mapping.put((Object)variant.getId(), (Object)variant);
            }
        }
        return mapping;
    }

    private FileWithID extractLeadingFile() {
        for (VariationPoint vp : this.variationPoints) {
            for (Variant var : vp.getVariants()) {
                IPath path = Path.fromOSString((String)((SoftwareElement)var.getImplementingElements().get(0)).getSourceLocation().getFilePath());
                String absfilePath = path.toOSString();
                if (this.leadingFile != null || !var.getLeading().booleanValue() || !this.isValidLeading(absfilePath)) continue;
                return new FileWithID(new File(absfilePath), var.getId());
            }
        }
        return null;
    }

    private boolean isValidLeading(String absfilePath) {
        return FilenameUtils.getBaseName((String)absfilePath).equals(this.proccessedFileName);
    }

    private List<FileWithID> extractIntegrationFiles() {
        ArrayList<FileWithID> integrationCopies = new ArrayList<FileWithID>();
        for (VariationPoint vp : this.variationPoints) {
            for (Variant var : vp.getVariants()) {
                boolean isNewIntegration;
                IPath path = Path.fromOSString((String)((SoftwareElement)var.getImplementingElements().get(0)).getSourceLocation().getFilePath());
                String absfilePath = path.toOSString();
                boolean bl = isNewIntegration = var.getLeading() == false && !CollectionUtil.containsFileWithId(var.getId(), integrationCopies) && this.isValidIntegration(absfilePath);
                if (!isNewIntegration) continue;
                integrationCopies.add(new FileWithID(new File(absfilePath), var.getId()));
            }
        }
        return integrationCopies;
    }

    private boolean isValidIntegration(String absfilePath) {
        if (this.leadingFile != null) {
            if (new File(absfilePath).getName().equals(this.leadingFile.getFile().getName())) {
                return true;
            }
        } else {
            LOGGER.error((Object)"No leading file is set to check the integration copy with!");
        }
        return false;
    }

    public List<NumbersTextPair> getLeadingCopy() {
        return UnifiedDiffFileHandler.getInstance().readLeadingFileToData(this.leadingFile);
    }

    public List<String[]> getIntegrationCopies() {
        return UnifiedDiffFileHandler.getInstance().readIntegrationCopies(this.integrationCopyList);
    }

    public int getIntegrationCopyCount() {
        return this.integrationCopyList.size();
    }

    public MarkerType getMarkerTypeFor(int line) {
        MarkerType marker = MarkerType.NONE;
        List<IndexedLineNumber> lineNumbers = this.unifiedLines.get(line).getLineNumbers();
        if (lineNumbers.size() > 1) {
            boolean isMixed;
            boolean bl = isMixed = !this.containsColumnIndex(lineNumbers, 0);
            if (isMixed) {
                marker = this.isPOI(lineNumbers) ? MarkerType.MIXED_DARK : MarkerType.MIXED_LIGHT;
            }
        } else {
            int colCount = this.integrationCopyList.size() + 1;
            int i = 0;
            while (i < colCount) {
                if (this.containsColumnIndex(lineNumbers, i)) {
                    marker = this.isPOI(lineNumbers) ? UIConstants.INDEX_TO_MARKERTYPE.get(i * 2) : UIConstants.INDEX_TO_MARKERTYPE.get(i * 2 + 1);
                }
                ++i;
            }
        }
        return marker;
    }

    private boolean containsColumnIndex(List<IndexedLineNumber> lineNumbers, int index) {
        for (IndexedLineNumber lineNumber : lineNumbers) {
            if (lineNumber == null || lineNumber.getColumnIndex() != index) continue;
            return true;
        }
        return false;
    }

    private boolean isPOI(List<IndexedLineNumber> lineNumbers) {
        for (IndexedLineNumber lineNumber : lineNumbers) {
            if (!this.poiExists(lineNumber.getColumnIndex(), lineNumber.getNumber())) continue;
            return true;
        }
        return false;
    }

    private boolean poiExists(int columnIndex, int lineNumber) {
        if (columnIndex == 0) {
            for (UnifiedPOI poi : this.leadingPOIs) {
                if (poi.getLineNumber() != lineNumber) continue;
                return true;
            }
        } else {
            for (UnifiedPOI poi : this.integrationPOIs) {
                if (this.indexOfIntegrationCopy(poi.getFilePath()) != columnIndex || poi.getLineNumber() != lineNumber) continue;
                return true;
            }
        }
        return false;
    }

    private int indexOfIntegrationCopy(String filePath) {
        int i = 0;
        while (i < this.integrationCopyList.size()) {
            if (this.integrationCopyList.get(i).getFile().getAbsolutePath().equals(filePath)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasVPsFor(List<IndexedLineNumber> lineNumbers) {
        boolean[] hasLineNumbers = new boolean[lineNumbers.size()];
        Arrays.fill(hasLineNumbers, false);
        for (IndexedLineNumber iLineNumber : lineNumbers) {
            List<Variant> variants = this.getVariantsForColumn(iLineNumber.getColumnIndex());
            for (Variant variant : variants) {
                SoftwareElement swElement = (SoftwareElement)variant.getImplementingElements().get(0);
                if (swElement.getSourceLocation().getStartLine() != iLineNumber.getNumber()) continue;
                hasLineNumbers[lineNumbers.indexOf((Object)iLineNumber)] = true;
            }
        }
        boolean[] blArray = hasLineNumbers;
        int n = hasLineNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            boolean hasLineNumber = blArray[n2];
            if (!hasLineNumber) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private List<Variant> getVariantsForColumn(int columnIndex) {
        String idForColumn = this.leadingFile.getID();
        if (columnIndex > 0) {
            idForColumn = this.integrationCopyList.get(columnIndex - 1).getID();
        }
        return (List)this.idToVariants.get((Object)idForColumn);
    }

    public List<FileLineNumberPair> getFileInformationFor(int unifiedLineNumber) {
        ArrayList<FileLineNumberPair> fileInfos = new ArrayList<FileLineNumberPair>();
        if (unifiedLineNumber <= this.unifiedLines.size()) {
            NumbersTextPair unifiedLine = this.unifiedLines.get(unifiedLineNumber);
            for (IndexedLineNumber lineNumber : unifiedLine.getLineNumbers()) {
                int sourceLineNumber = lineNumber.getNumber();
                if (lineNumber.getColumnIndex() == 0) {
                    FileLineNumberPair fileInfo = new FileLineNumberPair(this.leadingFile.getFile(), sourceLineNumber);
                    fileInfos.add(fileInfo);
                    continue;
                }
                File integrationFile = this.integrationCopyList.get(lineNumber.getColumnIndex() - 1).getFile();
                FileLineNumberPair fileInfo = new FileLineNumberPair(integrationFile, sourceLineNumber);
                fileInfos.add(fileInfo);
            }
        } else {
            LOGGER.warn((Object)("The connected line " + unifiedLineNumber + " does not exist!"));
        }
        return fileInfos;
    }

    public void setUnifiedLines(List<NumbersTextPair> unifiedLines) {
        this.unifiedLines = unifiedLines;
        if (this.unifiedDiffFile != null && this.unifiedDiffFile.exists()) {
            try {
                UnifiedDiffFileHandler.getInstance().writeUnifiedLines(this.getUnifiedTextLines(), this.unifiedDiffFile);
            }
            catch (IOException exception) {
                LOGGER.error((Object)"An error occured while writing data to the unified difference working copy!", (Throwable)exception);
            }
        }
    }

    public List<String> getUnifiedTextLines() {
        ArrayList<String> unifiedTextLines = new ArrayList<String>();
        for (NumbersTextPair numberTextPair : this.unifiedLines) {
            unifiedTextLines.add(numberTextPair.getLineText());
        }
        return unifiedTextLines;
    }

    public List<List<IndexedLineNumber>> getUnifiedLineNumbers() {
        ArrayList<List<IndexedLineNumber>> unifiedLineNumbers = new ArrayList<List<IndexedLineNumber>>();
        for (NumbersTextPair lineData : this.unifiedLines) {
            unifiedLineNumbers.add(lineData.getLineNumbers());
        }
        return unifiedLineNumbers;
    }

    public String getProccessedFileName() {
        return this.proccessedFileName;
    }

    public List<UnifiedPOI> getLeadingPOIs() {
        return this.leadingPOIs;
    }

    public List<UnifiedPOI> getIntegrationPOIs() {
        return this.integrationPOIs;
    }

    public static enum MarkerType {
        NONE,
        LEADING_LIGHT,
        LEADING_DARK,
        INTEGRATION1_LIGHT,
        INTEGRATION1_DARK,
        INTEGRATION2_LIGHT,
        INTEGRATION2_DARK,
        INTEGRATION3_LIGHT,
        INTEGRATION3_DARK,
        MIXED_LIGHT,
        MIXED_DARK;

    }
}

