/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.sourceconnection.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.editors.UnifiedDiffEditorInput;
import org.splevo.ui.refinementbrowser.VPMRefinementBrowser;
import org.splevo.ui.sourceconnection.UnifiedDiffConnector;
import org.splevo.ui.sourceconnection.handler.OpenSourceHandlerBase;
import org.splevo.ui.util.CollectionUtil;
import org.splevo.ui.vpexplorer.explorer.VPExplorer;
import org.splevo.vpm.variability.Variant;

public class OpenUnifiedDiffHandler
extends OpenSourceHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(OpenUnifiedDiffHandler.class);

    @Override
    protected void handle(Set<Variant> variants, IWorkbenchPart sendingPart) {
        SPLevoProject splevoProject = this.getSPLevoProjectFromWorkbenchPart(sendingPart);
        if (splevoProject != null) {
            this.handle(variants, splevoProject);
        } else {
            LOGGER.warn((Object)"Could not get the current SPLevo project!");
        }
    }

    private SPLevoProject getSPLevoProjectFromWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof VPExplorer) {
            return ((VPExplorer)workbenchPart).getSPLevoProject();
        }
        if (workbenchPart instanceof VPMRefinementBrowser) {
            return ((VPMRefinementBrowser)workbenchPart).getSPLevoProjectEditor().getSplevoProject();
        }
        LOGGER.warn((Object)"Handler was called from unknown source!");
        return null;
    }

    private void handle(Set<Variant> variantsOfInterest, SPLevoProject splevoProject) {
        List<String> fileNames = this.extractNamesOfFilesToProcess(variantsOfInterest);
        for (String fileName : fileNames) {
            File tmpWorkingCopyFile = null;
            try {
                tmpWorkingCopyFile = this.createUnifedDiffWorkspace(fileName, splevoProject);
                tmpWorkingCopyFile.deleteOnExit();
            }
            catch (IOException exception) {
                LOGGER.error((Object)"An error occured while creating the unified difference workspace!", (Throwable)exception);
            }
            Set<Variant> variantsToConsider = this.extractVariantsToConsider(fileName, variantsOfInterest);
            if (tmpWorkingCopyFile == null) continue;
            UnifiedDiffConnector diffConnector = new UnifiedDiffConnector(splevoProject, variantsToConsider, tmpWorkingCopyFile, fileName);
            diffConnector.calculateDifference(UnifiedDiffConnector.DiffMethod.BY_BLOCKS);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath loc = Path.fromOSString((String)tmpWorkingCopyFile.getPath());
            IFile ifile = workspace.getRoot().getFileForLocation(loc);
            try {
                ifile.refreshLocal(0, null);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new UnifiedDiffEditorInput(ifile, diffConnector), "org.splevo.ui.editors.unifieddiffeditor");
            }
            catch (PartInitException exception) {
                LOGGER.error((Object)"Error initializing the unified difference editor.", (Throwable)exception);
            }
            catch (CoreException exception) {
                LOGGER.error((Object)"Error refreshing the local project workspace.", (Throwable)exception);
            }
        }
    }

    private File createUnifedDiffWorkspace(String fileName, SPLevoProject splevoProject) throws IOException {
        String absWorkspacePath = WorkspaceUtil.getAbsoluteFromWorkspaceRelativePath((String)splevoProject.getWorkspace());
        File directory = new File(String.valueOf(absWorkspacePath) + "unified difference");
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Error creating the temporary working directory at \"" + directory.getAbsolutePath() + ".");
        }
        return this.createUnifiedDiffWorkingCopy(fileName, directory);
    }

    private File createUnifiedDiffWorkingCopy(String fileName, File directory) throws IOException {
        int index = 1;
        String tmpFileName = "unifiedDiff_" + fileName + ".java";
        File tmpFile = new File(this.combineToPath(directory, tmpFileName));
        if (tmpFile.exists()) {
            while ((tmpFile = new File(this.combineToPath(directory, tmpFileName = "unifiedDiff_" + fileName + index++ + ".java"))).exists()) {
            }
        }
        tmpFile.createNewFile();
        return tmpFile;
    }

    private String combineToPath(File parent, String childPath) {
        File file = new File(parent, childPath);
        return file.getPath();
    }

    private List<String> extractNamesOfFilesToProcess(Set<Variant> variants) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Variant variant : variants) {
            String fileName = FilenameUtils.getBaseName((String)this.getFilePathFor(variant));
            if (CollectionUtil.containsString(fileName, fileNames)) continue;
            fileNames.add(fileName);
        }
        return fileNames;
    }

    private Set<Variant> extractVariantsToConsider(String fileName, Set<Variant> variants) {
        HashSet<Variant> variantsToConsider = new HashSet<Variant>();
        for (Variant variant : variants) {
            String variantFileName = FilenameUtils.getBaseName((String)this.getFilePathFor(variant));
            if (!variantFileName.equals(fileName)) continue;
            variantsToConsider.add(variant);
        }
        return variantsToConsider;
    }

    private String getFilePathFor(Variant variant) {
        return variant.getVariationPoint().getLocation().getSourceLocation().getFilePath();
    }
}

