/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.vpmgraph;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.wb.swt.ResourceManager;
import org.graphstream.graph.Edge;
import org.splevo.ui.views.vpmgraph.VPMGraphView;
import org.splevo.vpm.analyzer.graph.RelationshipEdge;

class HideEdgeLabelAction
extends Action {
    private static final String ATTRIBUTE_KEY_UI_LABEL = "ui.label";
    private static final String TEXT_SHOW_EDGE_LABELS = "Show edge labels";
    private static final String TEXT_HIDE_EDGE_LABELS = "Hide edge labels";
    private static final String ICON_ACTIVE = "icons/active/hideconnector.gif";
    private Logger logger = Logger.getLogger(HideEdgeLabelAction.class);
    private VPMGraphView vpmGraphView;

    public HideEdgeLabelAction(VPMGraphView vpmGraphView) {
        super("Hide Edge Label Action", 2);
        this.vpmGraphView = vpmGraphView;
        this.setToolTipText(TEXT_HIDE_EDGE_LABELS);
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor("org.splevo.ui", ICON_ACTIVE));
        this.setChecked(false);
    }

    public void run() {
        if (this.vpmGraphView.getVpmGraph() == null) {
            this.logger.warn((Object)"No VPMGraph present in VPMGraph view.");
            return;
        }
        this.toggleLabels();
    }

    private void toggleLabels() {
        if (this.isChecked()) {
            for (Edge currentEdge : this.vpmGraphView.getVpmGraph().getEdgeSet()) {
                currentEdge.removeAttribute(ATTRIBUTE_KEY_UI_LABEL);
            }
            this.setToolTipText(TEXT_HIDE_EDGE_LABELS);
        } else {
            for (Edge currentEdge : this.vpmGraphView.getVpmGraph().getEdgeSet()) {
                RelationshipEdge relEdge = (RelationshipEdge)currentEdge;
                if (relEdge.getRelationshipLabels().size() <= 0) continue;
                StringBuilder labelBuilder = new StringBuilder();
                for (String label : relEdge.getRelationshipLabels()) {
                    labelBuilder.append(label);
                }
                currentEdge.addAttribute(ATTRIBUTE_KEY_UI_LABEL, new Object[]{labelBuilder.toString()});
            }
            this.setToolTipText(TEXT_SHOW_EDGE_LABELS);
        }
    }
}

