/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.vpmgraph;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.splevo.ui.views.vpmgraph.VPMGraphProvider;
import org.splevo.ui.views.vpmgraph.VPMGraphView;
import org.splevo.vpm.analyzer.graph.VPMGraph;

public class OpenVPMGraphViewerRunnable
implements Runnable {
    private Logger logger = Logger.getLogger(OpenVPMGraphViewerRunnable.class);
    private VPMGraphProvider vpmGraphProvider;

    public OpenVPMGraphViewerRunnable(VPMGraphProvider vpmGraphProvider) {
        this.vpmGraphProvider = vpmGraphProvider;
    }

    @Override
    public void run() {
        IViewPart viewPart;
        VPMGraph graph = this.vpmGraphProvider.getVpmGraph();
        if (graph == null) {
            this.logger.error((Object)"No VPMGraph loaded in blackboard.");
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)"VPMGraph not available", (String)"No Variation Point Graph detected in the SPLevo blackboard");
        }
        try {
            viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.splevo.ui.viewer.vpmgraph.VPMGraphViewer", "vpmgraph" + graph.getId(), 1);
        }
        catch (PartInitException e) {
            this.logger.error((Object)"Unable to open VPM Graph view.", (Throwable)e);
            return;
        }
        final VPMGraphView view = (VPMGraphView)viewPart;
        view.showGraph(graph);
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                activePage.hideView((IViewPart)view);
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }
}

