/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.views.vpproperties;

import com.google.common.base.Objects;
import org.splevo.refactoring.VariabilityRefactoring;
import org.splevo.refactoring.VariabilityRefactoringRegistry;
import org.splevo.ui.views.vpproperties.PropertySource;
import org.splevo.vpm.variability.VariationPoint;

public class VariationPointPropertySource
extends PropertySource {
    private final VariationPoint vp;

    public VariationPointPropertySource(VariationPoint vp) {
        this.vp = vp;
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("variabilitytype")) {
            return variabilityTypes.indexOf(this.vp.getVariabilityType().getName());
        }
        if (id.equals("extensibile")) {
            return extensibilities.indexOf(this.vp.getExtensibility().getName());
        }
        if (id.equals("bindingtime")) {
            return bindingTimes.indexOf(this.vp.getBindingTime().getName());
        }
        if (id.equals("variabilitymechanism")) {
            if (this.vp.getVariabilityMechanism() == null) {
                return null;
            }
            String refactoringId = this.vp.getVariabilityMechanism().getRefactoringID();
            VariabilityRefactoring refactoring = (VariabilityRefactoring)VariabilityRefactoringRegistry.getInstance().getElementById((Object)refactoringId);
            return refactoring;
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        Object oldValue = this.getPropertyValue(id);
        if (Objects.equal((Object)oldValue, (Object)value)) {
            return;
        }
        this.setPropertyValue(id, value, oldValue, this.vp);
    }
}

