/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.workflow;

import com.google.common.collect.Lists;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import de.uka.ipd.sdq.workflow.workbench.AbstractWorkbenchDelegate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.splevo.diffing.Differ;
import org.splevo.diffing.DifferRegistry;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.jobs.DiffingJob;
import org.splevo.ui.jobs.ExtractionJob;
import org.splevo.ui.jobs.InitVPMJob;
import org.splevo.ui.jobs.OpenVPMJob;
import org.splevo.ui.jobs.RefreshWorkspaceJob;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.jobs.SaveVPMJob;
import org.splevo.ui.workflow.BasicSPLevoWorkflowConfiguration;

public class InitVPMWorkflowDelegate
extends AbstractWorkbenchDelegate<BasicSPLevoWorkflowConfiguration, UIBasedWorkflow<Blackboard<?>>> {
    private BasicSPLevoWorkflowConfiguration config = null;

    public InitVPMWorkflowDelegate(BasicSPLevoWorkflowConfiguration config) {
        this.config = config;
    }

    protected IJob createWorkflowJob(BasicSPLevoWorkflowConfiguration config) {
        SequentialBlackboardInteractingJob jobSequence = new SequentialBlackboardInteractingJob();
        jobSequence.setBlackboard((Blackboard)new SPLevoBlackBoard());
        SPLevoProject splevoProject = config.getSplevoProjectEditor().getSplevoProject();
        List<String> requiredExtractors = this.getRequiredExtractors(splevoProject);
        for (String extractorId : requiredExtractors) {
            ExtractionJob leadingExtractionJob = new ExtractionJob(extractorId, splevoProject, true);
            ExtractionJob integrationExtractionJob = new ExtractionJob(extractorId, splevoProject, false);
            jobSequence.add((IJob)leadingExtractionJob);
            jobSequence.add((IJob)integrationExtractionJob);
        }
        jobSequence.add((IJob)new RefreshWorkspaceJob());
        DiffingJob diffingJob = new DiffingJob(splevoProject);
        jobSequence.add((IJob)diffingJob);
        InitVPMJob initVPMJob = new InitVPMJob(splevoProject);
        jobSequence.add((IJob)initVPMJob);
        String targetPath = String.valueOf(splevoProject.getWorkspace()) + "models/vpms/initial-vpm.vpm";
        SaveVPMJob saveVPMJob = new SaveVPMJob(splevoProject, targetPath, false);
        jobSequence.add((IJob)saveVPMJob);
        jobSequence.add((IJob)new OpenVPMJob(splevoProject, null));
        return jobSequence;
    }

    private List<String> getRequiredExtractors(SPLevoProject splevoProject) {
        ArrayList requiredExtractors = Lists.newArrayList();
        EList differIds = splevoProject.getDifferIds();
        for (String differId : differIds) {
            Differ differ = (Differ)DifferRegistry.getInstance().getElementById((Object)differId);
            if (differ == null) continue;
            requiredExtractors.addAll(differ.getRequiredExtractorIds());
        }
        return requiredExtractors;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean useSeparateConsoleForEachJobRun() {
        return false;
    }

    protected BasicSPLevoWorkflowConfiguration getConfiguration() {
        return this.config;
    }
}

