/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.ui.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.ParallelBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialJob;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import de.uka.ipd.sdq.workflow.workbench.AbstractWorkbenchDelegate;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.splevo.project.SPLevoProject;
import org.splevo.ui.commons.util.WorkspaceUtil;
import org.splevo.ui.jobs.CloseAnalysisTraceLogAppenderJob;
import org.splevo.ui.jobs.DetectRefinementsJob;
import org.splevo.ui.jobs.InitVPMGraphJob;
import org.splevo.ui.jobs.LoadVPMJob;
import org.splevo.ui.jobs.MergeVPMAnalyzerResultsIntoGraphJob;
import org.splevo.ui.jobs.SPLevoBlackBoard;
import org.splevo.ui.jobs.SaveRefinementModelJob;
import org.splevo.ui.jobs.VPMAnalysisJob;
import org.splevo.ui.workflow.VPMAnalysisWorkflowConfiguration;
import org.splevo.vpm.analyzer.VPMAnalyzer;

public class VPMAnalysisWorkflowDelegate
extends AbstractWorkbenchDelegate<VPMAnalysisWorkflowConfiguration, UIBasedWorkflow<Blackboard<?>>> {
    private Logger logger = Logger.getLogger(VPMAnalysisWorkflowDelegate.class);
    private VPMAnalysisWorkflowConfiguration config;
    private SPLevoBlackBoard blackboard;
    private boolean executeRefinementDetection;

    public VPMAnalysisWorkflowDelegate(VPMAnalysisWorkflowConfiguration config, SPLevoBlackBoard blackboard, boolean executeRefinementDetection) {
        this.config = config;
        this.blackboard = blackboard;
        this.executeRefinementDetection = executeRefinementDetection;
    }

    protected IJob createWorkflowJob(VPMAnalysisWorkflowConfiguration config) {
        SPLevoProject splevoProject = config.getSplevoProjectEditor().getSplevoProject();
        SequentialBlackboardInteractingJob jobSequence = new SequentialBlackboardInteractingJob();
        jobSequence.setBlackboard((Blackboard)this.blackboard);
        LoadVPMJob loadVPMJob = new LoadVPMJob(splevoProject);
        jobSequence.add((IJob)loadVPMJob);
        InitVPMGraphJob initVPMGraphJob = new InitVPMGraphJob();
        jobSequence.add((IJob)initVPMGraphJob);
        ParallelBlackboardInteractingJob parallelJob = new ParallelBlackboardInteractingJob();
        if (config.getAnalyzers().size() < 1) {
            this.logger.error((Object)"No analysis to perform configured.");
            return null;
        }
        this.logger.info((Object)"Intialize Analysis Log");
        this.initializeAnalysisLog();
        for (VPMAnalyzer analyzerInstance : config.getAnalyzers()) {
            VPMAnalysisJob vpmAnalysisJob = new VPMAnalysisJob(analyzerInstance);
            parallelJob.add((IJob)vpmAnalysisJob);
        }
        jobSequence.add((IJob)parallelJob);
        MergeVPMAnalyzerResultsIntoGraphJob mergeVPMAnalyzerResultsJob = new MergeVPMAnalyzerResultsIntoGraphJob();
        jobSequence.add((IJob)mergeVPMAnalyzerResultsJob);
        if (this.executeRefinementDetection) {
            this.addRefinementDetectionJobs((SequentialJob)jobSequence, splevoProject);
        }
        jobSequence.add((IJob)new CloseAnalysisTraceLogAppenderJob());
        return jobSequence;
    }

    private void initializeAnalysisLog() {
        SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String logFile = WorkspaceUtil.getAbsoluteFromProjectRelativePath((String)("logs/vpm-analysis-" + logDateFormat.format(new Date()) + ".csv"), (SPLevoProject)this.config.getSplevoProjectEditor().getSplevoProject());
        FileAppender fa = new FileAppender();
        fa.setName("VPM Analysis Trace Log Appender");
        fa.setFile(logFile);
        fa.setLayout((Layout)new PatternLayout("%m%n"));
        fa.setThreshold((Priority)Level.DEBUG);
        fa.setAppend(false);
        fa.activateOptions();
        Logger.getLogger((String)"analysislog").removeAllAppenders();
        Logger.getLogger((String)"analysislog").addAppender((Appender)fa);
        Logger.getLogger((String)"analysislog").info((Object)"Analyzer,VP1, VP2, SourceInfo, TargetInfo, Remark");
    }

    private void addRefinementDetectionJobs(SequentialJob compositeJob, SPLevoProject splevoProject) {
        DetectRefinementsJob createRefinementModelJob = new DetectRefinementsJob(this.config.getDetectionRules(), this.config.isUseMergeDetection(), this.config.isFullRefinementReasons());
        compositeJob.add((IJob)createRefinementModelJob);
        SaveRefinementModelJob saveRefinementModelJob = new SaveRefinementModelJob(splevoProject, SaveRefinementModelJob.FORMAT.CSV);
        compositeJob.add((IJob)saveRefinementModelJob);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean useSeparateConsoleForEachJobRun() {
        return false;
    }

    protected VPMAnalysisWorkflowConfiguration getConfiguration() {
        return this.config;
    }
}

