/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.codelocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.graphstream.graph.Node;
import org.splevo.vpm.analyzer.AbstractVPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.VariationPoint;

public class CodeLocationVPMAnalyzer
extends AbstractVPMAnalyzer {
    public static final String RELATIONSHIP_LABEL_CODE_LOCATION = "CodeLocation";
    private Logger logger = Logger.getLogger(CodeLocationVPMAnalyzer.class);

    public VPMAnalyzerResult analyze(VPMGraph vpmGraph) {
        VPMAnalyzerResult result = new VPMAnalyzerResult((VPMAnalyzer)this);
        Map<SoftwareElement, List<Node>> structureMap = this.fillStructureMap(vpmGraph);
        this.logger.debug((Object)("Grouped " + vpmGraph.getNodeCount() + " Nodes into " + structureMap.keySet().size() + " buckets."));
        for (SoftwareElement astNode : structureMap.keySet()) {
            if (structureMap.get(astNode).size() <= 1) continue;
            this.buildNodeEdgeDescriptors(result, structureMap.get(astNode), astNode);
        }
        return result;
    }

    private void buildNodeEdgeDescriptors(VPMAnalyzerResult result, List<Node> nodeList, SoftwareElement softwareElement) {
        ArrayList edgeRegistry = new ArrayList();
        for (Node node1 : nodeList) {
            for (Node node2 : nodeList) {
                VPMEdgeDescriptor descriptor;
                if (node1 == node2 || (descriptor = this.buildEdgeDescriptor(node1, node2, "", edgeRegistry)) == null) continue;
                result.getEdgeDescriptors().add(descriptor);
            }
        }
    }

    private Map<SoftwareElement, List<Node>> fillStructureMap(VPMGraph vpmGraph) {
        HashMap<SoftwareElement, List<Node>> structureMap = new HashMap<SoftwareElement, List<Node>>();
        for (Node node : vpmGraph.getNodeSet()) {
            SoftwareElement softwareElement;
            VariationPoint vp = (VariationPoint)node.getAttribute("vp.vp", VariationPoint.class);
            if (vp == null || (softwareElement = vp.getLocation()) == null) continue;
            if (!structureMap.containsKey(softwareElement)) {
                structureMap.put(softwareElement, new ArrayList());
            }
            ((List)structureMap.get(softwareElement)).add(node);
        }
        return structureMap;
    }

    public String getName() {
        return "Code Location VPM Analyzer";
    }

    public String getRelationshipLabel() {
        return RELATIONSHIP_LABEL_CODE_LOCATION;
    }

    public VPMAnalyzerConfigurationSet getConfigurations() {
        return new VPMAnalyzerConfigurationSet();
    }
}

