/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.semantic.lucene;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.splevo.vpm.analyzer.semantic.lucene.CodeTokenizer;
import org.splevo.vpm.analyzer.semantic.lucene.Stemming;

public class LuceneCodeAnalyzer
extends Analyzer {
    private static Logger logger = Logger.getLogger(LuceneCodeAnalyzer.class);
    private static final Version LUCENE_VERSION = Version.LUCENE_47;
    private CharArraySet stopWords;
    private boolean splitCamelCase;
    private Stemming stemming;
    private Set<String> featuredTerms = null;
    private boolean featuredTermsOnly = true;

    public LuceneCodeAnalyzer(String[] stopWords, boolean splitCamelCase, Stemming stemming) {
        this.stopWords = this.stemAndTransformToCharArray(stopWords, stemming);
        this.splitCamelCase = splitCamelCase;
        this.stemming = stemming;
    }

    public LuceneCodeAnalyzer(String[] stopWords, boolean splitCamelCase, Stemming stemming, Set<String> featuredTerms, boolean featuredTermsOnly) {
        this(stopWords, splitCamelCase, stemming);
        this.featuredTerms = featuredTerms;
        this.featuredTermsOnly = featuredTermsOnly;
    }

    protected Analyzer.TokenStreamComponents createComponents(String field, Reader reader) {
        CodeTokenizer tokenizer = new CodeTokenizer(reader, this.splitCamelCase, this.featuredTerms, this.featuredTermsOnly);
        LowerCaseFilter currentStream = new LowerCaseFilter(LUCENE_VERSION, (TokenStream)tokenizer);
        currentStream = new LengthFilter(LUCENE_VERSION, (TokenStream)currentStream, 3, Integer.MAX_VALUE);
        currentStream = Stemming.wrapStemmingFilter((TokenStream)currentStream, this.stemming);
        currentStream = new StopFilter(LUCENE_VERSION, (TokenStream)currentStream, this.stopWords);
        currentStream = new StandardFilter(LUCENE_VERSION, (TokenStream)currentStream);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)currentStream);
    }

    private CharArraySet stemAndTransformToCharArray(String[] stopWords, Stemming stemming) {
        stopWords = LuceneCodeAnalyzer.stemWords(stopWords, stemming);
        CharArraySet charArraySet = new CharArraySet(LUCENE_VERSION, Arrays.asList(stopWords), true);
        return charArraySet;
    }

    public static String[] stemWords(String[] words, Stemming stemming) {
        HashSet stemmedStopWords = Sets.newHashSet();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            StandardTokenizer tokenStream = new StandardTokenizer(LUCENE_VERSION, (Reader)new StringReader(word));
            tokenStream = Stemming.wrapStemmingFilter((TokenStream)tokenStream, stemming);
            CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            try {
                tokenStream.reset();
                while (tokenStream.incrementToken()) {
                    String term = charTermAttribute.toString();
                    stemmedStopWords.add(term);
                }
            }
            catch (IOException e) {
                logger.error((Object)"Failed to stem a list of words", (Throwable)e);
            }
            ++n2;
        }
        return stemmedStopWords.toArray(new String[0]);
    }
}

