/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.refinement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMAnalyzerTestUtil;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.codelocation.CodeLocationVPMAnalyzer;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.analyzer.mergedecider.MergeDecider;
import org.splevo.vpm.analyzer.mergedecider.MergeDeciderRegistry;
import org.splevo.vpm.analyzer.refinement.BasicDetectionRule;
import org.splevo.vpm.analyzer.refinement.DetectionRule;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementType;
import org.splevo.vpm.variability.VariationPoint;

public class MergeDetectionTest {
    @BeforeClass
    public static void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Before
    public void before() {
        MergeDeciderRegistry.getInstance().clearRegistry();
    }

    @After
    public void after() {
        MergeDeciderRegistry.getInstance().clearRegistry();
    }

    @Test
    public void testMergeDetection() throws Exception {
        VPMGraph graph = new VPMGraph("VPMGraph");
        VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP1");
        VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP2");
        VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP3");
        VPMAnalyzerResult resultCS = new VPMAnalyzerResult((VPMAnalyzer)new CodeLocationVPMAnalyzer());
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP1", "VP2"));
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP2", "VP3"));
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP1", "VP3"));
        ArrayList<VPMAnalyzerResult> results = new ArrayList<VPMAnalyzerResult>();
        results.add(resultCS);
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        service.createGraphEdges(graph, results);
        MergeDecider mergeDecider = (MergeDecider)Mockito.mock(MergeDecider.class);
        OngoingStubbing methodCallStub = Mockito.when((Object)mergeDecider.canBeMerged((VariationPoint)Matchers.any(VariationPoint.class), (VariationPoint)Matchers.any(VariationPoint.class)));
        methodCallStub = methodCallStub.thenReturn((Object)Boolean.TRUE);
        methodCallStub = methodCallStub.thenReturn((Object)Boolean.FALSE);
        methodCallStub.thenReturn((Object)Boolean.FALSE);
        MergeDeciderRegistry.getInstance().registerElement((Object)mergeDecider);
        BasicDetectionRule rule = new BasicDetectionRule((List)Lists.newArrayList((Object[])new String[]{"CodeStructure"}), RefinementType.GROUPING);
        List refinements = service.deriveRefinements(graph, (List)Lists.newArrayList((Object[])new DetectionRule[]{rule}), true, true);
        Assert.assertThat((String)"Wrong number of top level refinements", (Object)refinements.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Top level refinement must be grouping", (Object)((Refinement)refinements.get(0)).getType(), (Matcher)CoreMatchers.is((Object)RefinementType.GROUPING));
        Assert.assertThat((String)"Sub refinement expected", (Object)((Refinement)refinements.get(0)).getSubRefinements().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wron sub refinement type", (Object)((Refinement)((Refinement)refinements.get(0)).getSubRefinements().get(0)).getType(), (Matcher)CoreMatchers.is((Object)RefinementType.MERGE));
    }

    @Test
    public void testMergeOnly() throws Exception {
        VPMGraph graph = new VPMGraph("VPMGraph");
        VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP1");
        VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP2");
        VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP3");
        VPMAnalyzerResult resultCS = new VPMAnalyzerResult((VPMAnalyzer)new CodeLocationVPMAnalyzer());
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP1", "VP2"));
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP2", "VP3"));
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP1", "VP3"));
        ArrayList<VPMAnalyzerResult> results = new ArrayList<VPMAnalyzerResult>();
        results.add(resultCS);
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        service.createGraphEdges(graph, results);
        MergeDecider mergeDecider = (MergeDecider)Mockito.mock(MergeDecider.class);
        OngoingStubbing methodCallStub = Mockito.when((Object)mergeDecider.canBeMerged((VariationPoint)Matchers.any(VariationPoint.class), (VariationPoint)Matchers.any(VariationPoint.class)));
        methodCallStub = methodCallStub.thenReturn((Object)Boolean.TRUE);
        methodCallStub.thenReturn((Object)Boolean.TRUE);
        MergeDeciderRegistry.getInstance().registerElement((Object)mergeDecider);
        BasicDetectionRule rule = new BasicDetectionRule((List)Lists.newArrayList((Object[])new String[]{"CodeStructure"}), RefinementType.GROUPING);
        List refinements = service.deriveRefinements(graph, (List)Lists.newArrayList((Object[])new DetectionRule[]{rule}), true, true);
        Assert.assertThat((String)"Wrong number of refinements", (Object)refinements.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong type of refinement", (Object)((Refinement)refinements.get(0)).getType(), (Matcher)CoreMatchers.is((Object)RefinementType.MERGE));
    }

    @Test
    public void testTransitiveMerge() throws Exception {
        VPMGraph graph = new VPMGraph("VPMGraph");
        VariationPoint vp1 = (VariationPoint)VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP1").getAttribute("vp.vp");
        VariationPoint vp2 = (VariationPoint)VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP2").getAttribute("vp.vp");
        VariationPoint vp3 = (VariationPoint)VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP3").getAttribute("vp.vp");
        VariationPoint vp4 = (VariationPoint)VPMAnalyzerTestUtil.createNodeWithVP(graph, "VP4").getAttribute("vp.vp");
        VPMAnalyzerResult resultCS = new VPMAnalyzerResult((VPMAnalyzer)new CodeLocationVPMAnalyzer());
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP1", "VP2"));
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP1", "VP4"));
        resultCS.getEdgeDescriptors().add(new VPMEdgeDescriptor("CodeStructure", "Method", "VP3", "VP4"));
        ArrayList results = Lists.newArrayList((Object[])new VPMAnalyzerResult[]{resultCS});
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        service.createGraphEdges(graph, (List)results);
        MergeDecider mergeDecider = (MergeDecider)Mockito.mock(MergeDecider.class);
        Mockito.when((Object)mergeDecider.canBeMerged(vp1, vp2)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp1, vp3)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp1, vp4)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp2, vp3)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp2, vp4)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp3, vp4)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp2, vp1)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp3, vp1)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp4, vp1)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp3, vp2)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp4, vp2)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)mergeDecider.canBeMerged(vp4, vp3)).thenReturn((Object)Boolean.TRUE);
        MergeDeciderRegistry.getInstance().registerElement((Object)mergeDecider);
        BasicDetectionRule rule = new BasicDetectionRule((List)Lists.newArrayList((Object[])new String[]{"CodeStructure"}), RefinementType.GROUPING);
        List refinements = service.deriveRefinements(graph, (List)Lists.newArrayList((Object[])new DetectionRule[]{rule}), true, true);
        Assert.assertThat((String)"Wrong number of refinements", (Object)refinements.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong type of refinement", (Object)((Refinement)refinements.get(0)).getType(), (Matcher)CoreMatchers.is((Object)RefinementType.MERGE));
    }
}

