/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer;

import java.util.ArrayList;
import java.util.List;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.splevo.tests.SPLevoTestUtil;
import org.splevo.vpm.analyzer.AbstractTest;
import org.splevo.vpm.analyzer.DefaultVPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMAnalyzerTestUtil;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.codelocation.CodeLocationVPMAnalyzer;
import org.splevo.vpm.analyzer.graph.RelationshipEdge;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.analyzer.refinement.BasicDetectionRule;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementType;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointModel;

public class DefaultVPMAnalyzerServiceTest
extends AbstractTest {
    @Test
    public void testInitVPMGraph() throws Exception {
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        VariationPointModel vpm = SPLevoTestUtil.loadGCDVPMModel();
        VPMGraph graph = service.initVPMGraph(vpm);
        Assert.assertNotNull((String)"VPMGraph not allowed to be null.", (Object)graph);
        Assert.assertEquals((String)"Wrong number of vertices.", (long)7L, (long)graph.getNodeCount());
    }

    @Test
    public void testMergeGraphs() throws InterruptedException {
        VPMGraph graph1 = new VPMGraph("VPMGraph");
        Node node1A = VPMAnalyzerTestUtil.createNode((Graph)graph1, "A");
        Node node1B = VPMAnalyzerTestUtil.createNode((Graph)graph1, "B");
        Node node1C = VPMAnalyzerTestUtil.createNode((Graph)graph1, "C");
        Node node1D = VPMAnalyzerTestUtil.createNode((Graph)graph1, "D");
        VPMGraph graph2 = new VPMGraph("VPMGraph");
        Node node2A = VPMAnalyzerTestUtil.createNode((Graph)graph2, "A");
        Node node2B = VPMAnalyzerTestUtil.createNode((Graph)graph2, "B");
        Node node2C = VPMAnalyzerTestUtil.createNode((Graph)graph2, "C");
        Node node2D = VPMAnalyzerTestUtil.createNode((Graph)graph2, "D");
        RelationshipEdge edge1 = (RelationshipEdge)graph1.addEdge("structure.e1", node1A, node1B);
        edge1.addRelationshipLabel("Structure");
        RelationshipEdge edge2 = (RelationshipEdge)graph2.addEdge("flow.e1", node2C, node2D);
        edge2.addRelationshipLabel("Flow");
        RelationshipEdge edge3 = (RelationshipEdge)graph2.addEdge("flow.e2", node2A, node2B);
        edge3.addRelationshipLabel("Flow");
        ArrayList<VPMGraph> graphs = new ArrayList<VPMGraph>();
        graphs.add(graph1);
        graphs.add(graph2);
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        VPMGraph graph = service.mergeGraphs(graphs);
        Assert.assertNotNull((String)"Merge did not return any graph", (Object)graph);
        Assert.assertEquals((String)"Wrong number of merged edges", (long)2L, (long)graph.getEdgeCount());
    }

    @Test
    public void testMergeGraphEdges() throws InterruptedException {
        VPMGraph graph = new VPMGraph("VPMGraph");
        Node nodeVP1 = VPMAnalyzerTestUtil.createNode((Graph)graph, "VP1");
        Node nodeVP2 = VPMAnalyzerTestUtil.createNode((Graph)graph, "VP2");
        RelationshipEdge edge1 = (RelationshipEdge)graph.addEdge("CodeStructure#VP1#VP2", nodeVP1, nodeVP2);
        edge1.addRelationshipLabel("CodeStructure");
        RelationshipEdge edge2 = (RelationshipEdge)graph.addEdge("ProgramDependency#VP1#VP2", nodeVP1, nodeVP2);
        edge2.addRelationshipLabel("ProgramDependency");
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        service.mergeGraphEdges(graph);
        Assert.assertNotNull((String)"Merged graph is null", (Object)graph);
        Assert.assertEquals((String)"Wrong number of merged edges", (long)1L, (long)graph.getEdgeCount());
        Assert.assertEquals((String)"wrong merged edge id", (Object)"VP1#VP2", (Object)graph.getEdge(0).getId());
    }

    @Test
    public void testCreateGraphEdges() throws InterruptedException {
        VPMGraph graph = new VPMGraph("VPMGraph");
        VPMAnalyzerTestUtil.createNode((Graph)graph, "VP1");
        VPMAnalyzerTestUtil.createNode((Graph)graph, "VP2");
        VPMAnalyzerTestUtil.createNode((Graph)graph, "VP3");
        VPMAnalyzerTestUtil.createNode((Graph)graph, "VP4");
        VPMAnalyzerResult resultCS = new VPMAnalyzerResult((VPMAnalyzer)new CodeLocationVPMAnalyzer());
        VPMEdgeDescriptor descriptorVP1VP2 = new VPMEdgeDescriptor("CodeStructure", "Method", "VP1", "VP2");
        resultCS.getEdgeDescriptors().add(descriptorVP1VP2);
        VPMEdgeDescriptor descriptorVP3VP4CS = new VPMEdgeDescriptor("CodeStructure", "Method", "VP3", "VP4");
        resultCS.getEdgeDescriptors().add(descriptorVP3VP4CS);
        VPMAnalyzerResult resultPD = new VPMAnalyzerResult((VPMAnalyzer)new CodeLocationVPMAnalyzer());
        VPMEdgeDescriptor descriptorVP3VP4PD = new VPMEdgeDescriptor("ProgramDependency", "Variable", "VP3", "VP4");
        resultPD.getEdgeDescriptors().add(descriptorVP3VP4PD);
        ArrayList<VPMAnalyzerResult> results = new ArrayList<VPMAnalyzerResult>();
        results.add(resultCS);
        results.add(resultPD);
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        service.createGraphEdges(graph, results);
        Assert.assertNotNull((String)"Merged graph is null", (Object)graph);
        Assert.assertEquals((String)"Wrong number of merged edges", (long)2L, (long)graph.getEdgeCount());
        Assert.assertNotNull((String)"Missing Edge VP3#VP4 (Maybe wrong id creation)", (Object)graph.getEdge("VP3#VP4"));
        Assert.assertTrue((String)"Unexpected Edge VP4#VP3 (Wrong id creation)", (graph.getEdge("VP4#VP3") == null ? 1 : 0) != 0);
    }

    @Test
    public void testDeriveRefinements() throws Exception {
        VPMGraph graph = SPLevoTestUtil.loadGCDVPMGraph();
        Node node1 = graph.getNode(0);
        Node node2 = graph.getNode(1);
        RelationshipEdge edge = (RelationshipEdge)graph.addEdge("structure.e1", node1, node2);
        edge.addRelationshipLabel("Flow");
        edge.addRelationshipLabel("Structure");
        ArrayList<String> detectionSpecs = new ArrayList<String>();
        detectionSpecs.add("Flow");
        detectionSpecs.add("Structure");
        BasicDetectionRule rule = new BasicDetectionRule(detectionSpecs, RefinementType.GROUPING);
        ArrayList<BasicDetectionRule> detectionRules = new ArrayList<BasicDetectionRule>();
        detectionRules.add(rule);
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        List refinements = service.deriveRefinements(graph, detectionRules, true, true);
        Assert.assertNotNull((String)"Unexpected null value. At least an empty list is expected", (Object)refinements);
        Assert.assertThat((String)"Wrong number of refinements", (Object)refinements.size(), (Matcher)CoreMatchers.is((Object)1));
        Refinement refinement = (Refinement)refinements.get(0);
        Assert.assertEquals((String)"Wrong number of VPs in refinement", (long)2L, (long)refinement.getVariationPoints().size());
        Assert.assertEquals((String)"Wrong refinement type", (Object)RefinementType.GROUPING, (Object)refinement.getType());
    }

    @Test
    public void testDeriveRefinementsGroupAware() throws Exception {
        VPMGraph graph = SPLevoTestUtil.loadGCDVPMGraph();
        Node node1 = graph.getNode(0);
        Node node2 = graph.getNode(1);
        VariationPoint vp1 = (VariationPoint)node1.getAttribute("vp.vp");
        VariationPoint vp2 = (VariationPoint)node2.getAttribute("vp.vp");
        vp2.setGroup(vp1.getGroup());
        RelationshipEdge edge = (RelationshipEdge)graph.addEdge("structure.edge1", node1, node2);
        edge.addRelationshipLabel("Flow");
        edge.addRelationshipLabel("Structure");
        ArrayList<String> detectionSpecs = new ArrayList<String>();
        detectionSpecs.add("Flow");
        detectionSpecs.add("Structure");
        BasicDetectionRule rule = new BasicDetectionRule(detectionSpecs, RefinementType.GROUPING);
        ArrayList<BasicDetectionRule> detectionRules = new ArrayList<BasicDetectionRule>();
        detectionRules.add(rule);
        DefaultVPMAnalyzerService service = new DefaultVPMAnalyzerService();
        List refinements = service.deriveRefinements(graph, detectionRules, true, true);
        Assert.assertNotNull((String)"Unexpected null value. At least an empty list is expected", (Object)refinements);
        Assert.assertThat((String)"There should be no recommended refinement", (Object)refinements.size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

