/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer.config;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.splevo.vpm.analyzer.config.AbstractVPMAnalyzerConfiguration;
import org.splevo.vpm.analyzer.config.BooleanConfiguration;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;

public class VPMAnalyzerConfigurationsTest {
    @Test
    public final void testVPMAnalyzerConfigurations() {
        VPMAnalyzerConfigurationSet configSet = new VPMAnalyzerConfigurationSet();
        int size = configSet.getAllConfigurationsByGroupName().size();
        Assert.assertSame((String)"Map size should be 0 after initialization.", (Object)0, (Object)size);
    }

    @Test
    public final void testAddConfigurationsAndGetAllConfigurationsByGroupName1() {
        VPMAnalyzerConfigurationSet configSet = new VPMAnalyzerConfigurationSet();
        BooleanConfiguration conf1 = new BooleanConfiguration("ID1", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        BooleanConfiguration conf2 = new BooleanConfiguration("ID2", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        BooleanConfiguration conf3 = new BooleanConfiguration("ID3", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        configSet.addConfigurations("Test", new AbstractVPMAnalyzerConfiguration[]{conf1, conf2, conf3});
        int size = configSet.getAllConfigurationsByGroupName().size();
        Assert.assertSame((String)"Map size should be 1.", (Object)1, (Object)size);
        int numElements = ((List)configSet.getAllConfigurationsByGroupName().get("Test")).size();
        Assert.assertSame((String)"This key should have 3 elements.", (Object)3, (Object)numElements);
    }

    @Test
    public final void testAddConfigurationsAndGetAllConfigurationsByGroupName2() {
        VPMAnalyzerConfigurationSet configSet = new VPMAnalyzerConfigurationSet();
        BooleanConfiguration conf1 = new BooleanConfiguration("ID1", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        BooleanConfiguration conf2 = new BooleanConfiguration("ID2", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        BooleanConfiguration conf3 = new BooleanConfiguration("ID3", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        configSet.addConfigurations("Test1", new AbstractVPMAnalyzerConfiguration[]{conf1, conf2, conf3});
        BooleanConfiguration conf4 = new BooleanConfiguration("ID4", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        BooleanConfiguration conf5 = new BooleanConfiguration("ID5", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        BooleanConfiguration conf6 = new BooleanConfiguration("ID6", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        configSet.addConfigurations("Test2", new AbstractVPMAnalyzerConfiguration[]{conf4, conf5, conf6});
        int size = configSet.getAllConfigurationsByGroupName().size();
        Assert.assertSame((String)"Map size should be 1.", (Object)2, (Object)size);
        int numElements1 = ((List)configSet.getAllConfigurationsByGroupName().get("Test1")).size();
        int numElements2 = ((List)configSet.getAllConfigurationsByGroupName().get("Test2")).size();
        Assert.assertSame((String)"This key should have 3 elements.", (Object)3, (Object)numElements1);
        Assert.assertSame((String)"This key should have 3 elements.", (Object)3, (Object)numElements2);
    }

    @Test
    public final void testConfigIDUniqueInSet() {
        VPMAnalyzerConfigurationSet configSet = new VPMAnalyzerConfigurationSet();
        BooleanConfiguration conf1 = new BooleanConfiguration("ID1", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        BooleanConfiguration conf2 = new BooleanConfiguration("ID1", "LABEL", "EXPLANATION", Boolean.valueOf(true));
        configSet.addConfigurations("Test1", new AbstractVPMAnalyzerConfiguration[]{conf1, conf2});
        int size = configSet.getAllConfigurationsByGroupName().size();
        Assert.assertSame((String)"Map size should be 1.", (Object)1, (Object)size);
        int count = ((List)configSet.getAllConfigurationsByGroupName().get("Test1")).size();
        Assert.assertSame((String)"This key should have 1 elements.", (Object)1, (Object)count);
    }
}

