/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer;

import java.util.List;
import org.apache.log4j.Logger;
import org.graphstream.graph.Node;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.config.VPMAnalyzerConfigurationSet;

public abstract class AbstractVPMAnalyzer
implements VPMAnalyzer {
    private Logger analysisLogger = Logger.getLogger((String)"analysislog");

    @Override
    public abstract String getRelationshipLabel();

    @Override
    public abstract VPMAnalyzerConfigurationSet getConfigurations();

    protected void logAnalysisInfo(String vp1ID, String vp2ID, String sourceInfo, String targetInfo) {
        this.logAnalysisInfo(vp1ID, vp2ID, sourceInfo, targetInfo, "");
    }

    protected void logAnalysisInfo(String vp1ID, String vp2ID, String sourceInfo, String targetInfo, String remark) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(this.getRelationshipLabel());
        logMessage.append(",");
        logMessage.append(vp1ID);
        logMessage.append(",");
        logMessage.append(vp2ID);
        logMessage.append(",");
        logMessage.append(sourceInfo);
        logMessage.append(",");
        logMessage.append(targetInfo);
        logMessage.append(",");
        logMessage.append('\"');
        logMessage.append(remark);
        logMessage.append('\"');
        this.analysisLogger.info((Object)logMessage.toString());
    }

    protected String buildEdgeRegistryID(Node node1, Node node2) {
        if (node1.getId().compareTo(node2.getId()) < 0) {
            return String.valueOf(node1.getId()) + "#" + node2.getId();
        }
        return String.valueOf(node2.getId()) + "#" + node1.getId();
    }

    public String buildEdgeId(Node node1, Node node2) {
        if (node1.getId().compareTo(node2.getId()) < 0) {
            return String.valueOf(this.getRelationshipLabel()) + "#" + node1.getId() + "#" + node2.getId();
        }
        return String.valueOf(this.getRelationshipLabel()) + "#" + node2.getId() + "#" + node1.getId();
    }

    public VPMEdgeDescriptor buildEdgeDescriptor(Node node1, Node node2, String relationshipSubLabel, List<String> edgeRegistry) {
        VPMEdgeDescriptor descriptor = null;
        String edgeRegistryID = this.buildEdgeRegistryID(node1, node2);
        if (!edgeRegistry.contains(edgeRegistryID)) {
            edgeRegistry.add(edgeRegistryID);
            descriptor = new VPMEdgeDescriptor(this.getRelationshipLabel(), relationshipSubLabel, node1.getId(), node2.getId());
        }
        return descriptor;
    }
}

