/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerRegistry;
import org.splevo.vpm.analyzer.VPMAnalyzerResult;
import org.splevo.vpm.analyzer.VPMAnalyzerService;
import org.splevo.vpm.analyzer.VPMEdgeDescriptor;
import org.splevo.vpm.analyzer.graph.RelationshipEdge;
import org.splevo.vpm.analyzer.graph.VPMGraph;
import org.splevo.vpm.analyzer.mergedecider.MergeDecider;
import org.splevo.vpm.analyzer.mergedecider.MergeDeciderRegistry;
import org.splevo.vpm.analyzer.refinement.DetectionRule;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementFactory;
import org.splevo.vpm.refinement.RefinementType;
import org.splevo.vpm.refinement.RefinementUtil;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class DefaultVPMAnalyzerService
implements VPMAnalyzerService {
    private static Logger logger = Logger.getLogger(DefaultVPMAnalyzerService.class);
    private static final String NEW_LINE = System.getProperty("line.separator");

    @Override
    public VPMGraph initVPMGraph(VariationPointModel vpm) {
        VPMGraph graph = new VPMGraph("VPMGraph");
        int nodeIndex = 0;
        for (VariationPointGroup vpGroup : vpm.getVariationPointGroups()) {
            for (VariationPoint vp : vpGroup.getVariationPoints()) {
                String nodeID = "VP" + nodeIndex++;
                Node n = graph.addNode(nodeID);
                n.addAttribute("ui.label", new Object[]{nodeID});
                n.addAttribute("vp.vp", new Object[]{vp});
            }
        }
        return graph;
    }

    @Override
    public VPMGraph mergeGraphs(List<VPMGraph> graphs) {
        if (graphs.size() == 0) {
            return null;
        }
        VPMGraph graph = graphs.get(0);
        for (VPMGraph currentGraph : graphs) {
            if (currentGraph == graph) continue;
            for (Edge edge : currentGraph.getEachEdge()) {
                String edgeId = edge.getId();
                String sourceNodeId = edge.getSourceNode().getId();
                String targetNodeId = edge.getTargetNode().getId();
                Node sourceNode = graph.getNode(sourceNodeId);
                Edge mergeEdge = sourceNode.getEdgeBetween(targetNodeId);
                if (mergeEdge == null) {
                    mergeEdge = graph.addEdge(edgeId, sourceNodeId, targetNodeId);
                    for (String key : edge.getAttributeKeySet()) {
                        mergeEdge.addAttribute(key, new Object[]{edge.getAttribute(key)});
                    }
                    continue;
                }
                RelationshipEdge relEdge = (RelationshipEdge)edge;
                RelationshipEdge relMergeEdge = (RelationshipEdge)mergeEdge;
                relMergeEdge.getRelationshipInfos().addAll(relEdge.getRelationshipInfos());
                relMergeEdge.getRelationshipLabels().addAll(relEdge.getRelationshipLabels());
            }
        }
        return graph;
    }

    @Override
    public void mergeGraphEdges(VPMGraph vpmGraph) {
        for (Edge edge : vpmGraph.getEachEdge()) {
            Node targetNode;
            Node sourceNode = edge.getSourceNode();
            String edgeId = this.buildEdgeId(sourceNode, targetNode = edge.getTargetNode());
            Object mergeEdge = vpmGraph.getEdge(edgeId);
            if (mergeEdge == null) {
                mergeEdge = vpmGraph.addEdge(edgeId, sourceNode, targetNode);
                for (String key : edge.getAttributeKeySet()) {
                    mergeEdge.addAttribute(key, new Object[]{edge.getAttribute(key)});
                }
            } else {
                RelationshipEdge relEdge = (RelationshipEdge)edge;
                RelationshipEdge relMergeEdge = (RelationshipEdge)((Object)mergeEdge);
                relMergeEdge.getRelationshipInfos().addAll(relEdge.getRelationshipInfos());
                relMergeEdge.getRelationshipLabels().addAll(relEdge.getRelationshipLabels());
            }
            vpmGraph.removeEdge(edge);
        }
    }

    @Override
    public void createGraphEdges(VPMGraph vpmGraph, List<VPMAnalyzerResult> analyzerResults) {
        for (VPMAnalyzerResult analyzerResult : analyzerResults) {
            for (VPMEdgeDescriptor edgeDescriptor : analyzerResult.getEdgeDescriptors()) {
                String targetNodeId;
                String sourceNodeId = edgeDescriptor.getSourceNodeID();
                String edgeId = this.buildEdgeId(sourceNodeId, targetNodeId = edgeDescriptor.getTargetNodeID());
                Edge mergeEdge = vpmGraph.getEdge(edgeId);
                RelationshipEdge relationShipEdge = mergeEdge == null ? (RelationshipEdge)vpmGraph.addEdge(edgeId, sourceNodeId, targetNodeId) : (RelationshipEdge)mergeEdge;
                relationShipEdge.addRelationshipLabel(edgeDescriptor.getRelationshipLabel());
                relationShipEdge.addRelationshipInfo(edgeDescriptor.getRelationshipSubLabel());
            }
        }
    }

    private String buildEdgeId(Node node1, Node node2) {
        return this.buildEdgeId(node1.getId(), node2.getId());
    }

    private String buildEdgeId(String node1ID, String node2ID) {
        if (node1ID.compareTo(node2ID) <= 0) {
            return String.valueOf(node1ID) + "#" + node2ID;
        }
        return String.valueOf(node2ID) + "#" + node1ID;
    }

    @Override
    public List<Refinement> deriveRefinements(VPMGraph vpmGraph, List<DetectionRule> detectionRules, boolean useMergeDetection, boolean fullRefinementReasons) {
        ArrayList<Refinement> refinements = new ArrayList<Refinement>();
        for (DetectionRule rule : detectionRules) {
            List<Refinement> ruleRefinements = rule.detect(vpmGraph, fullRefinementReasons);
            if (useMergeDetection) {
                ruleRefinements = this.mergeDetection(ruleRefinements);
            }
            ruleRefinements = this.filterUnreasonable(ruleRefinements);
            refinements.addAll(ruleRefinements);
        }
        return refinements;
    }

    private List<Refinement> filterUnreasonable(List<Refinement> ruleRefinements) {
        LinkedList filteredRefinements = Lists.newLinkedList();
        for (Refinement refinement : ruleRefinements) {
            boolean connectingRefinement = this.isConnectingRefinement(refinement);
            if (!connectingRefinement && this.isGroupingOfAlllreadyGroupedVPs(refinement)) continue;
            filteredRefinements.add(refinement);
        }
        return filteredRefinements;
    }

    private boolean isConnectingRefinement(Refinement refinement) {
        boolean connectingRefinement = false;
        if (refinement.getSubRefinements().size() > 1) {
            connectingRefinement = true;
        } else if (refinement.getSubRefinements().size() == 1 && refinement.getVariationPoints().size() > 0) {
            connectingRefinement = true;
        }
        return connectingRefinement;
    }

    private boolean isGroupingOfAlllreadyGroupedVPs(Refinement refinement) {
        boolean sameGroup = false;
        if (refinement.getType() == RefinementType.GROUPING) {
            LinkedHashSet groups = Sets.newLinkedHashSet();
            for (VariationPoint vp : refinement.getVariationPoints()) {
                groups.add(vp.getGroup());
            }
            if (groups.size() == 1) {
                sameGroup = true;
            }
        }
        return sameGroup;
    }

    private List<Refinement> mergeDetection(List<Refinement> detectedRefinements) {
        logger.info((Object)"Run merge detection");
        LinkedList refinedRefinements = Lists.newLinkedList();
        for (Refinement origRefinement : detectedRefinements) {
            EList variationPoints = origRefinement.getVariationPoints();
            Multimap<VariationPoint, VariationPoint> mergeVPBuckets = this.identifyMergeableVPs((EList<VariationPoint>)variationPoints);
            this.checkDistinctBuckets(mergeVPBuckets);
            if (mergeVPBuckets.size() == 0) {
                refinedRefinements.add(origRefinement);
                continue;
            }
            Refinement updatedRefinements = this.createMergeRefinements(origRefinement, mergeVPBuckets);
            refinedRefinements.add(updatedRefinements);
        }
        return refinedRefinements;
    }

    private Refinement createMergeRefinements(Refinement origRefinement, Multimap<VariationPoint, VariationPoint> mergeVPBuckets) {
        boolean mergesToConnectOrUnmergedVPs;
        ArrayList newRefinements = Lists.newArrayList();
        ArrayList vpsNotMerged = Lists.newArrayList((Iterable)origRefinement.getVariationPoints());
        for (VariationPoint bucketKey : mergeVPBuckets.keySet()) {
            Refinement mergeRefinement = this.buildMergeRefinementForBucket(origRefinement, mergeVPBuckets, bucketKey);
            vpsNotMerged.removeAll((Collection<?>)mergeRefinement.getVariationPoints());
            newRefinements.add(mergeRefinement);
        }
        boolean bl = mergesToConnectOrUnmergedVPs = vpsNotMerged.size() > 0 || newRefinements.size() > 1;
        if (mergesToConnectOrUnmergedVPs) {
            Refinement connectingRefinement = this.buildConnectingGroupRefinement(origRefinement, vpsNotMerged);
            connectingRefinement.getSubRefinements().addAll((Collection)newRefinements);
            return connectingRefinement;
        }
        if (newRefinements.size() == 1) {
            return (Refinement)newRefinements.get(0);
        }
        logger.error((Object)"Tried to merge an empty VP set.");
        return null;
    }

    private Multimap<VariationPoint, VariationPoint> identifyMergeableVPs(EList<VariationPoint> variationPoints) {
        LinkedHashMultimap mergeVPBuckets = LinkedHashMultimap.create();
        IdentityHashMap invertedBucketIndex = Maps.newIdentityHashMap();
        VariationPoint[] vpArray = (VariationPoint[])variationPoints.toArray((Object[])new VariationPoint[0]);
        int i = 0;
        while (i < vpArray.length) {
            VariationPoint vp1 = vpArray[i];
            int j = i + 1;
            while (j < vpArray.length) {
                VariationPoint vp2 = vpArray[j];
                if (vp1 == vp2) {
                    logger.error((Object)"Comparing a VP with itself should not happen");
                } else if (this.canBeMerged(vp1, vp2)) {
                    VariationPoint bucketKey = this.chooseBucket((Multimap<VariationPoint, VariationPoint>)mergeVPBuckets, invertedBucketIndex, vp1, vp2);
                    invertedBucketIndex.put(vp2, bucketKey);
                    mergeVPBuckets.get((Object)bucketKey).add(vp2);
                    invertedBucketIndex.put(vp1, bucketKey);
                    mergeVPBuckets.get((Object)bucketKey).add(vp1);
                }
                ++j;
            }
            ++i;
        }
        return mergeVPBuckets;
    }

    private void checkDistinctBuckets(Multimap<VariationPoint, VariationPoint> buckets) {
        LinkedHashMap vpHits = Maps.newLinkedHashMap();
        for (VariationPoint key : buckets.keySet()) {
            for (VariationPoint vp : buckets.get((Object)key)) {
                if (vpHits.containsKey(vp)) {
                    logger.error((Object)"VP contained in more than one merge bucket");
                }
                vpHits.put(vp, key);
            }
        }
    }

    private Refinement buildConnectingGroupRefinement(Refinement originalRefinement, List<VariationPoint> vpsNotMerged) {
        Refinement groupRefinement = RefinementFactory.eINSTANCE.createRefinement();
        groupRefinement.setType(RefinementType.GROUPING);
        groupRefinement.setRefinementModel(originalRefinement.getRefinementModel());
        groupRefinement.getVariationPoints().addAll(vpsNotMerged);
        StringBuilder source = new StringBuilder();
        source.append("Group refinement to connect related VPs that could be partially merged");
        source.append(NEW_LINE);
        source.append(originalRefinement.getSource());
        groupRefinement.setSource(source.toString());
        groupRefinement.getReasons().addAll((Collection)originalRefinement.getReasons());
        return groupRefinement;
    }

    private Refinement buildMergeRefinementForBucket(Refinement originalRefinement, Multimap<VariationPoint, VariationPoint> buckets, VariationPoint key) {
        Refinement mergeRefinement = RefinementFactory.eINSTANCE.createRefinement();
        mergeRefinement.setType(RefinementType.MERGE);
        mergeRefinement.setRefinementModel(originalRefinement.getRefinementModel());
        mergeRefinement.getVariationPoints().add((Object)key);
        mergeRefinement.getVariationPoints().addAll(buckets.get((Object)key));
        List reasons = RefinementUtil.getReasons((Refinement)originalRefinement, (Collection)buckets.get((Object)key));
        originalRefinement.getReasons().removeAll((Collection)reasons);
        mergeRefinement.getReasons().addAll((Collection)reasons);
        int mergedVPCount = mergeRefinement.getVariationPoints().size();
        int origVPCount = originalRefinement.getVariationPoints().size();
        StringBuilder source = new StringBuilder();
        source.append(mergedVPCount);
        source.append(" of ");
        source.append(origVPCount);
        source.append(" VPs detected to mergeable.");
        source.append(NEW_LINE);
        source.append(originalRefinement.getSource());
        mergeRefinement.setSource(source.toString());
        return mergeRefinement;
    }

    private VariationPoint chooseBucket(Multimap<VariationPoint, VariationPoint> mergeVPBuckets, Map<VariationPoint, VariationPoint> invertedBucketIndex, VariationPoint vpReference, VariationPoint vpUnderStudy) {
        boolean underStudyIsInBucket;
        VariationPoint bucketKeyReference = invertedBucketIndex.get(vpReference);
        VariationPoint bucketKeyUnderStudy = invertedBucketIndex.get(vpUnderStudy);
        boolean referenceIsInBucket = bucketKeyReference != null;
        boolean bl = underStudyIsInBucket = bucketKeyUnderStudy != null;
        if (referenceIsInBucket && underStudyIsInBucket) {
            return this.mergeBuckets(mergeVPBuckets, bucketKeyReference, bucketKeyUnderStudy, invertedBucketIndex);
        }
        if (referenceIsInBucket) {
            return bucketKeyReference;
        }
        if (underStudyIsInBucket) {
            return bucketKeyUnderStudy;
        }
        return vpReference;
    }

    private VariationPoint mergeBuckets(Multimap<VariationPoint, VariationPoint> vpBuckets, VariationPoint survivingKey, VariationPoint mergInKey, Map<VariationPoint, VariationPoint> invertedBucketIndex) {
        if (survivingKey == mergInKey) {
            return survivingKey;
        }
        Collection mergeInVPs = vpBuckets.get((Object)mergInKey);
        for (VariationPoint mergeInVP : mergeInVPs) {
            invertedBucketIndex.put(mergeInVP, survivingKey);
        }
        vpBuckets.get((Object)survivingKey).addAll(mergeInVPs);
        vpBuckets.removeAll((Object)mergInKey);
        return survivingKey;
    }

    private boolean canBeMerged(VariationPoint vp1, VariationPoint vp2) {
        if (vp1 == null || vp2 == null) {
            logger.error((Object)"Mergeability checked for at least one VP being null");
        }
        for (MergeDecider decider : MergeDeciderRegistry.getInstance().getElements()) {
            boolean checkResult = decider.canBeMerged(vp1, vp2);
            if (!checkResult) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<VPMAnalyzer> getAvailableAnalyzers() {
        return VPMAnalyzerRegistry.getInstance().getElements();
    }
}

