/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.analyzer;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.splevo.vpm.analyzer.VPMAnalyzer;
import org.splevo.vpm.analyzer.VPMAnalyzerRegistry;
import org.splevo.vpm.analyzer.mergedecider.MergeDecider;
import org.splevo.vpm.analyzer.mergedecider.MergeDeciderRegistry;

public class Activator
implements BundleActivator {
    private static final String VPM_ANALYZER_EXTENSION_POINT_ID = "org.splevo.vpm.analyzer.analyzer";
    private static final String EXTENSION_POINT_ATTR_ANALYZER_CLASS = "analyzer.class";
    private static final String MERGE_DECIDER_EXTENSION_POINT_ID = "org.splevo.vpm.analyzer.mergedecider";
    private static final String MERGE_DECIDER_EXTENSION_POINT_ATTR_CLASS = "MergeDecider.class";
    private static Logger logger = Logger.getLogger(Activator.class);

    public void start(BundleContext context) throws Exception {
        Activator.loadAndRegisterVPMAnalyzerExtensions();
        Activator.loadAndRegisterMergeDeciderExtensions();
    }

    public void stop(BundleContext context) throws Exception {
    }

    private static void loadAndRegisterVPMAnalyzerExtensions() throws BundleException {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            throw new BundleException("No extension point registry available.");
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(VPM_ANALYZER_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            throw new BundleException("No extension point found for the ID org.splevo.vpm.analyzer.analyzer");
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurations;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object o = element.createExecutableExtension(EXTENSION_POINT_ATTR_ANALYZER_CLASS);
                    if (o != null && o instanceof VPMAnalyzer) {
                        VPMAnalyzer analyzer = (VPMAnalyzer)o;
                        VPMAnalyzerRegistry.getInstance().registerElement(analyzer);
                    }
                }
                catch (CoreException e) {
                    logger.error((Object)"Failed to load VPM analyzer extension", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void loadAndRegisterMergeDeciderExtensions() throws BundleException {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            throw new BundleException("No extension point registry available.");
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(MERGE_DECIDER_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            throw new BundleException("No extension point found for the ID org.splevo.vpm.analyzer.mergedecider");
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurations;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object o = element.createExecutableExtension(MERGE_DECIDER_EXTENSION_POINT_ATTR_CLASS);
                    if (o != null && o instanceof MergeDecider) {
                        MergeDecider mergeDecider = (MergeDecider)o;
                        MergeDeciderRegistry.getInstance().registerElement(mergeDecider);
                    }
                }
                catch (CoreException e) {
                    logger.error((Object)"Failed to load merge decider extension", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

