/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.variability.provider;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.splevo.vpm.realization.RealizationFactory;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.VariabilityType;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.provider.IdentifierItemProvider;
import org.splevo.vpm.variability.variabilityFactory;
import org.splevo.vpm.variability.variabilityPackage;

public class VariationPointItemProvider
extends IdentifierItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public VariationPointItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addDescriptionPropertyDescriptor(object);
            this.addLocationPropertyDescriptor(object);
            this.addVariabilityTypePropertyDescriptor(object);
            this.addBindingTimePropertyDescriptor(object);
            this.addExtensibilityPropertyDescriptor(object);
            this.addRefactoredPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_CustomizableNameHaving_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_CustomizableNameHaving_name_feature", "_UI_CustomizableNameHaving_type"), (EStructuralFeature)variabilityPackage.Literals.CUSTOMIZABLE_NAME_HAVING__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addDescriptionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_CustomizableDescriptionHaving_description_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_CustomizableDescriptionHaving_description_feature", "_UI_CustomizableDescriptionHaving_type"), (EStructuralFeature)variabilityPackage.Literals.CUSTOMIZABLE_DESCRIPTION_HAVING__DESCRIPTION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addLocationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_VariationPoint_location_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_VariationPoint_location_feature", "_UI_VariationPoint_type"), (EStructuralFeature)variabilityPackage.Literals.VARIATION_POINT__LOCATION, true, false, true, null, null, null));
    }

    protected void addVariabilityTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_VariationPoint_variabilityType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_VariationPoint_variabilityType_feature", "_UI_VariationPoint_type"), (EStructuralFeature)variabilityPackage.Literals.VARIATION_POINT__VARIABILITY_TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addBindingTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_VariationPoint_bindingTime_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_VariationPoint_bindingTime_feature", "_UI_VariationPoint_type"), (EStructuralFeature)variabilityPackage.Literals.VARIATION_POINT__BINDING_TIME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addExtensibilityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_VariationPoint_extensibility_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_VariationPoint_extensibility_feature", "_UI_VariationPoint_type"), (EStructuralFeature)variabilityPackage.Literals.VARIATION_POINT__EXTENSIBILITY, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addRefactoredPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_VariationPoint_refactored_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_VariationPoint_refactored_feature", "_UI_VariationPoint_type"), (EStructuralFeature)variabilityPackage.Literals.VARIATION_POINT__REFACTORED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(variabilityPackage.Literals.VARIATION_POINT__VARIANTS);
            this.childrenFeatures.add(variabilityPackage.Literals.VARIATION_POINT__VARIABILITY_MECHANISM);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        VariationPoint vp = (VariationPoint)object;
        Object baseImage = vp.getVariabilityType() == VariabilityType.XOR || vp.getVariabilityType() == VariabilityType.OPTXOR ? this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/VariationPointXOR")) : this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/VariationPoint"));
        return this.overlayVariantCount(baseImage, vp.getVariants().size());
    }

    private Object overlayVariantCount(Object baseImage, int count) {
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(baseImage);
        images.add(this.getResourceLocator().getImage("overlay/count-" + count));
        return new ComposedImage(images);
    }

    @Override
    public String getText(Object object) {
        VariationPoint vp = (VariationPoint)object;
        if (!Strings.isNullOrEmpty((String)vp.getName())) {
            return vp.getName();
        }
        Optional<SoftwareElement> firstImplementationElement = VariationPointItemProvider.getImplementingSoftwareElementFromVP(vp);
        StringBuilder label = new StringBuilder();
        if (firstImplementationElement.isPresent()) {
            label.append(((SoftwareElement)firstImplementationElement.get()).getQualifiedName());
        } else {
            label.append(this.getString("_UI_VariationPoint_type"));
            label.append(" in ");
            if (vp.getLocation() != null) {
                label.append(vp.getLocation().getLabel());
            } else {
                label.append("[TOP LEVEL]");
            }
        }
        return label.toString();
    }

    private static Optional<SoftwareElement> getImplementingSoftwareElementFromVP(VariationPoint vp) {
        Optional variantToUse = Iterables.tryFind((Iterable)vp.getVariants(), (Predicate)new Predicate<Variant>(){

            public boolean apply(Variant input) {
                return input.getLeading();
            }
        });
        if (!variantToUse.isPresent()) {
            variantToUse = Optional.fromNullable((Object)((Variant)Iterables.getFirst((Iterable)vp.getVariants(), null)));
        }
        Optional firstImplementationElement = Optional.absent();
        if (variantToUse.isPresent()) {
            firstImplementationElement = Optional.fromNullable((Object)((SoftwareElement)Iterables.getFirst((Iterable)((Variant)variantToUse.get()).getImplementingElements(), null)));
        }
        return firstImplementationElement;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(VariationPoint.class)) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: 
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(variabilityPackage.Literals.VARIATION_POINT__VARIANTS, variabilityFactory.eINSTANCE.createVariant()));
        newChildDescriptors.add(this.createChildParameter(variabilityPackage.Literals.VARIATION_POINT__VARIABILITY_MECHANISM, RealizationFactory.eINSTANCE.createVariabilityMechanism()));
    }
}

