/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.refinement.provider;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.splevo.vpm.refinement.Refinement;
import org.splevo.vpm.refinement.RefinementFactory;
import org.splevo.vpm.refinement.RefinementPackage;
import org.splevo.vpm.refinement.RefinementType;
import org.splevo.vpm.refinement.provider.RefinementEditPlugin;
import org.splevo.vpm.variability.provider.CustomizableDescriptionHavingItemProvider;

public class RefinementItemProvider
extends CustomizableDescriptionHavingItemProvider {
    public RefinementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdPropertyDescriptor(object);
            this.addTypePropertyDescriptor(object);
            this.addVariationPointsPropertyDescriptor(object);
            this.addSourcePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Refinement_id_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Refinement_id_feature", "_UI_Refinement_type"), (EStructuralFeature)RefinementPackage.Literals.REFINEMENT__ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Refinement_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Refinement_type_feature", "_UI_Refinement_type"), (EStructuralFeature)RefinementPackage.Literals.REFINEMENT__TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVariationPointsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Refinement_variationPoints_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Refinement_variationPoints_feature", "_UI_Refinement_type"), (EStructuralFeature)RefinementPackage.Literals.REFINEMENT__VARIATION_POINTS, true, false, true, null, null, null));
    }

    protected void addSourcePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Refinement_source_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Refinement_source_feature", "_UI_Refinement_type"), (EStructuralFeature)RefinementPackage.Literals.REFINEMENT__SOURCE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(RefinementPackage.Literals.REFINEMENT__SUB_REFINEMENTS);
            this.childrenFeatures.add(RefinementPackage.Literals.REFINEMENT__REASONS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public String getText(Object object) {
        if (object instanceof Refinement) {
            Refinement refinement = (Refinement)object;
            StringBuilder labelBuilder = new StringBuilder();
            if (Strings.isNullOrEmpty((String)refinement.getId())) {
                if (refinement.getType() == RefinementType.GROUPING) {
                    labelBuilder.append("Grouping");
                } else {
                    labelBuilder.append("Merge");
                }
                labelBuilder.append(" (");
                labelBuilder.append(refinement.getSubRefinements().size());
                labelBuilder.append("/");
                labelBuilder.append(refinement.getVariationPoints().size());
                labelBuilder.append(")");
            } else {
                labelBuilder.append(refinement.getId());
            }
            return labelBuilder.toString();
        }
        throw new RuntimeException("Unknown Refinement Type: " + object.getClass());
    }

    public Object getImage(Object object) {
        if (object instanceof Refinement) {
            if (((Refinement)object).getType().equals((Object)RefinementType.GROUPING)) {
                return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Grouping"));
            }
            return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Merge"));
        }
        return super.getImage(object);
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Refinement.class)) {
            case 1: 
            case 2: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 7: 
            case 8: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(RefinementPackage.Literals.REFINEMENT__SUB_REFINEMENTS, RefinementFactory.eINSTANCE.createRefinement()));
        newChildDescriptors.add(this.createChildParameter(RefinementPackage.Literals.REFINEMENT__REASONS, RefinementFactory.eINSTANCE.createRefinementReason()));
    }

    public ResourceLocator getResourceLocator() {
        return RefinementEditPlugin.INSTANCE;
    }
}

