/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.refinement;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RefinementType implements Enumerator
{
    MERGE(0, "MERGE", "MERGE"),
    GROUPING(1, "GROUPING", "GROUPING");

    public static final int MERGE_VALUE = 0;
    public static final int GROUPING_VALUE = 1;
    private static final RefinementType[] VALUES_ARRAY;
    public static final List<RefinementType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RefinementType[]{MERGE, GROUPING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RefinementType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RefinementType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RefinementType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RefinementType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RefinementType get(int value) {
        switch (value) {
            case 0: {
                return MERGE;
            }
            case 1: {
                return GROUPING;
            }
        }
        return null;
    }

    private RefinementType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

