/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.variability;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindingTime implements Enumerator
{
    COMPILE_TIME(0, "CompileTime", "CompileTime"),
    LOAD_TIME(3, "LoadTime", "LoadTime"),
    RUN_TIME(4, "RunTime", "RunTime");

    public static final int COMPILE_TIME_VALUE = 0;
    public static final int LOAD_TIME_VALUE = 3;
    public static final int RUN_TIME_VALUE = 4;
    private static final BindingTime[] VALUES_ARRAY;
    public static final List<BindingTime> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindingTime[]{COMPILE_TIME, LOAD_TIME, RUN_TIME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindingTime get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingTime result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingTime getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingTime result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingTime get(int value) {
        switch (value) {
            case 0: {
                return COMPILE_TIME;
            }
            case 3: {
                return LOAD_TIME;
            }
            case 4: {
                return RUN_TIME;
            }
        }
        return null;
    }

    private BindingTime(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

