/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.vpm.variability;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariabilityType implements Enumerator
{
    XOR(0, "XOR", "XOR"),
    OR(1, "OR", "OR"),
    OPTXOR(2, "OPTXOR", "OPTXOR"),
    OPTOR(3, "OPTOR", "OPTOR");

    public static final int XOR_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int OPTXOR_VALUE = 2;
    public static final int OPTOR_VALUE = 3;
    private static final VariabilityType[] VALUES_ARRAY;
    public static final List<VariabilityType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariabilityType[]{XOR, OR, OPTXOR, OPTOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariabilityType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityType get(int value) {
        switch (value) {
            case 0: {
                return XOR;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return OPTXOR;
            }
            case 3: {
                return OPTOR;
            }
        }
        return null;
    }

    private VariabilityType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

