/*
 * Decompiled with CFR 0.152.
 */
package de.devboost.featuremapper.splevo.builder.test;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import de.devboost.featuremapper.splevo.builder.FeatureMapperModelSet;
import de.devboost.featuremapper.splevo.builder.test.FeatureMapperModelsBuilderMock;
import de.devboost.natspec.annotations.TextSyntax;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.ClassifiersFactory;
import org.emftext.language.java.commons.Commentable;
import org.featuremapper.models.feature.Feature;
import org.featuremapper.models.feature.FeatureModel;
import org.featuremapper.models.feature.Group;
import org.featuremapper.models.featuremapping.ElementMapping;
import org.featuremapper.models.featuremapping.FeatureMappingModel;
import org.featuremapper.models.featuremapping.FeatureRef;
import org.featuremapper.models.featuremapping.Mapping;
import org.featuremapper.models.featuremapping.SolutionModelRef;
import org.junit.Assert;
import org.splevo.fm.builder.FeatureModelWrapper;
import org.splevo.jamopp.vpm.software.JaMoPPSoftwareElement;
import org.splevo.jamopp.vpm.software.softwareFactory;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;
import org.splevo.vpm.variability.variabilityFactory;

public class FeatureMapperBuilderTestSupport {
    private variabilityFactory factory = variabilityFactory.eINSTANCE;

    @TextSyntax(value="#1")
    public void matchAllPattern(List<String> words) {
        System.out.println(Joiner.on((String)" ").join(words));
    }

    @TextSyntax(value="If there is for example a variation point model named #1")
    public VariationPointModel forAnExampleVariationPointModelNamed(String VPM1) {
        VariationPointModel vpm = this.factory.createVariationPointModel();
        return vpm;
    }

    @TextSyntax(value="With a variation point #1")
    public VariationPoint withAVariationPointGroupThatHasVariationsAnd(String pointName, VariationPointModel vpm) {
        VariationPointGroup vpg = this.factory.createVariationPointGroup();
        vpg.setName(pointName);
        vpm.getVariationPointGroups().add((Object)vpg);
        EList variationPoints = vpg.getVariationPoints();
        VariationPoint vpa = this.factory.createVariationPoint();
        vpa.setRefactored(true);
        variationPoints.add((Object)vpa);
        return vpa;
    }

    @TextSyntax(value="That has a variant #1 mapped to class #2 in resource #3")
    public void thatHasVariationMappedToClass(String variantName, String exampleClassName, String resourceName, VariationPoint point) {
        Variant aVariant = this.factory.createVariant();
        aVariant.setId(variantName);
        JaMoPPSoftwareElement softwareEntity = softwareFactory.eINSTANCE.createJaMoPPSoftwareElement();
        Class jamoppClass = ClassifiersFactory.eINSTANCE.createClass();
        jamoppClass.setName(exampleClassName);
        ResourceImpl res = new ResourceImpl();
        URI uri = URI.createURI((String)resourceName);
        res.setURI(uri);
        res.getContents().add((Object)jamoppClass);
        softwareEntity.setJamoppElement((Commentable)jamoppClass);
        aVariant.getImplementingElements().add((Object)softwareEntity);
        point.getVariants().add((Object)aVariant);
    }

    @TextSyntax(value="Then the FeatureMapper Models Builder generates")
    public FeatureMapperModelSet theModelsBuilderWillGenerate(VariationPointModel vpm) {
        FeatureMapperModelsBuilderMock builder = new FeatureMapperModelsBuilderMock();
        FeatureModelWrapper fmWrapper = builder.build(vpm, "RootFeature");
        FeatureMapperModelSet featureModelSet = (FeatureMapperModelSet)fmWrapper.getModel();
        return featureModelSet;
    }

    @TextSyntax(value="A Feature Model")
    public FeatureModel aFeatureModel(FeatureMapperModelSet set) {
        FeatureModel featureModel = set.getFeatureModel();
        Assert.assertNotNull((Object)featureModel);
        return featureModel;
    }

    @TextSyntax(value="A Mapping Model")
    public FeatureMappingModel MappingModel(FeatureMapperModelSet set) {
        FeatureMappingModel mappingModel = set.getMappingModel();
        Assert.assertNotNull((Object)mappingModel);
        return mappingModel;
    }

    @TextSyntax(value="With a root feature #1")
    public Feature withARootFeature(String rootFeatureName, FeatureModel model) {
        String foundName = model.getRoot().getName();
        Assert.assertEquals((Object)rootFeatureName, (Object)foundName);
        return model.getRoot();
    }

    @TextSyntax(value="With #1 child features named #2")
    public void withChildFeaturesNamed(int childSize, List<String> childNames, Feature feature) {
        Iterable childNamesFiltered = Splitter.on((String)" and ").split((CharSequence)Joiner.on((String)" ").join(childNames));
        EList groups = feature.getGroups();
        LinkedList<String> foundChilds = new LinkedList<String>();
        for (Group g : groups) {
            EList childFeatures = g.getChildFeatures();
            for (Feature child : childFeatures) {
                String name = child.getName();
                foundChilds.add(name);
            }
        }
        Assert.assertEquals((long)childSize, (long)foundChilds.size());
        for (String expectedChild : childNamesFiltered) {
            Assert.assertTrue((String)("Expected child " + expectedChild), (boolean)foundChilds.contains(expectedChild));
        }
    }

    @TextSyntax(value="With feature #1 that contains 0 children")
    public void withChildFeaturesNamed(String featureName, FeatureModel model) {
        Feature feature = this.findFeatureNamed(featureName, model);
        EList groups = feature.getGroups();
        LinkedList<String> foundChilds = new LinkedList<String>();
        for (Group g : groups) {
            EList childFeatures = g.getChildFeatures();
            for (Feature child : childFeatures) {
                String name = child.getName();
                foundChilds.add(name);
            }
        }
        Assert.assertEquals((long)0L, (long)foundChilds.size());
    }

    @TextSyntax(value="With feature #1 that contains #2 child features named #3")
    public void withFeatureThatContainsChildFeaturesNamedAnd(String featurename, int childSize, List<String> childNames, FeatureModel model) {
        Feature parentFeature = this.findFeatureNamed(featurename, model);
        Assert.assertNotNull((Object)parentFeature);
        this.withChildFeaturesNamed(childSize, childNames, parentFeature);
    }

    private Feature findFeatureNamed(String featurename, FeatureModel model) {
        EList allFeatures = model.getAllFeatures();
        Feature parentFeature = null;
        for (Feature feature : allFeatures) {
            if (!feature.getName().equals(featurename)) continue;
            parentFeature = feature;
            break;
        }
        return parentFeature;
    }

    @TextSyntax(value="With a mapping of feature #1 to #2")
    public void withAMappingOfFeatureTo(String featureName, String artifactName, FeatureMappingModel mappingModel) {
        for (Mapping mapping : mappingModel.getMappings()) {
            if (!(mapping instanceof ElementMapping)) continue;
            ElementMapping em = (ElementMapping)mapping;
            Assert.assertTrue((boolean)(em.getTerm() instanceof FeatureRef));
            FeatureRef featureRef = (FeatureRef)em.getTerm();
            String featureNameFound = featureRef.getFeature().getName();
            if (!featureNameFound.equals(featureName)) continue;
            EObject element = em.getElement();
            Assert.assertEquals((Object)artifactName, (Object)((Class)element).getName());
            return;
        }
        Assert.fail((String)("No mapping found for feature " + featureName));
    }

    @TextSyntax(value="With solution space model #1")
    public void withSolutionSpaceModel(String resourceName, FeatureMappingModel model) {
        EList solutionModels = model.getSolutionModels();
        Assert.assertTrue((String)"No solution space models set.", (solutionModels.size() > 0 ? 1 : 0) != 0);
        for (SolutionModelRef solutionModelRef : solutionModels) {
            Class jamoppClass = (Class)solutionModelRef.getValue();
            if (!jamoppClass.eResource().getURI().toString().equals(resourceName)) continue;
            return;
        }
        Assert.fail((String)("Could not find solution space model: " + resourceName));
    }
}

