/*
 * Decompiled with CFR 0.152.
 */
package de.devboost.featuremapper.splevo.builder;

import de.devboost.featuremapper.splevo.builder.FeatureMapperModelSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.featuremapper.interpreter.emf.EMFInterpreter;
import org.featuremapper.models.feature.Feature;
import org.featuremapper.models.feature.FeatureFactory;
import org.featuremapper.models.feature.FeatureModel;
import org.featuremapper.models.feature.FeaturePackage;
import org.featuremapper.models.feature.Group;
import org.featuremapper.models.featuremapping.ElementMapping;
import org.featuremapper.models.featuremapping.FeatureMappingFactory;
import org.featuremapper.models.featuremapping.FeatureMappingModel;
import org.featuremapper.models.featuremapping.FeatureModelRef;
import org.featuremapper.models.featuremapping.FeatureRef;
import org.featuremapper.models.featuremapping.SolutionModelRef;
import org.featuremapper.models.featuremapping.Term;
import org.splevo.fm.builder.FeatureModelBuilder;
import org.splevo.fm.builder.FeatureModelWrapper;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class FeatureMapperModelsBuilder
implements FeatureModelBuilder<FeatureMapperModelSet> {
    private static Logger logger = Logger.getLogger(FeatureMapperModelsBuilder.class);
    private Map<String, Feature> cachedVariantFeatures = new HashMap<String, Feature>();
    public static final String FEATURE_MODEL_FILE_EXTENSION = "feature";
    public static final String FEATURE_MAPPING_FILE_EXTENSION = "featuremapping";

    public String getId() {
        return "de.devboost.featuremapper.splevo.builder";
    }

    public String getLabel() {
        return "FeatureMapper Models Builder";
    }

    public FeatureModelWrapper<FeatureMapperModelSet> build(VariationPointModel vpm, String rootFeatureName) {
        FeatureModel featureModel = this.initFeatureModel(vpm, rootFeatureName);
        FeatureMappingFactory mappingFactory = FeatureMappingFactory.eINSTANCE;
        FeatureMappingModel mappingModel = mappingFactory.createFeatureMappingModel();
        FeatureModelRef fmreference = mappingFactory.createFeatureModelRef();
        mappingModel.setComposerID(new EMFInterpreter().getID());
        mappingModel.setFeatureModel(fmreference);
        fmreference.setValue(featureModel);
        ArrayList<Resource> solutionModelResources = new ArrayList<Resource>();
        for (VariationPointGroup variationPointGroup : vpm.getVariationPointGroups()) {
            this.cachedVariantFeatures.clear();
            Feature vpFeature = this.createVariationPointGroupFeature(variationPointGroup, featureModel.getRoot());
            Group group = this.createMandatoryFeatureGroup();
            vpFeature.getGroups().add((Object)group);
            for (VariationPoint variationPoint : variationPointGroup.getVariationPoints()) {
                if (!variationPoint.isRefactored()) continue;
                for (Variant variant : variationPoint.getVariants()) {
                    Feature vFeature = this.createVariantFeature(variationPointGroup, variant);
                    vFeature.setMaxCardinality(1);
                    group.getChildFeatures().add((Object)vFeature);
                    EList softwareEntities = variant.getImplementingElements();
                    for (SoftwareElement softwareElement : softwareEntities) {
                        ElementMapping mapping = mappingFactory.createElementMapping();
                        FeatureRef featureRef = mappingFactory.createFeatureRef();
                        featureRef.setFeature(vFeature);
                        mapping.setTerm((Term)featureRef);
                        EObject wrappedElement = softwareElement.getWrappedElement();
                        mapping.setElement(wrappedElement);
                        Resource containingResource = wrappedElement.eResource();
                        URI fixedUri = this.getFixedURI(containingResource.getURI());
                        containingResource.setURI(fixedUri);
                        solutionModelResources.add(containingResource);
                        mappingModel.getMappings().add((Object)mapping);
                    }
                }
            }
        }
        ArrayList<String> knownResourceUris = new ArrayList<String>();
        for (Resource resource : solutionModelResources) {
            if (resource != null && !resource.getContents().isEmpty()) {
                String uriString = resource.getURI().toString();
                if (knownResourceUris.contains(uriString)) continue;
                knownResourceUris.add(uriString);
                EObject rootObject = (EObject)resource.getContents().get(0);
                SolutionModelRef solutionModelRef = mappingFactory.createSolutionModelRef();
                solutionModelRef.setValue(rootObject);
                mappingModel.getSolutionModels().add((Object)solutionModelRef);
                continue;
            }
            String resourceIdentifier = "unknown resource uri";
            if (resource != null && resource.getURI() != null) {
                resourceIdentifier = resource.getURI().toFileString();
            }
            logger.error((Object)("Could not create solution model reference for resource " + resourceIdentifier));
        }
        FeatureMapperModelSet featureMapperModelSet = new FeatureMapperModelSet(featureModel, mappingModel);
        return new FeatureModelWrapper((Object)featureMapperModelSet, true);
    }

    protected URI getFixedURI(URI uri) {
        URI fixedUri = uri;
        if (uri.isFile()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)uri.toFileString());
            IFile file = workspace.getRoot().getFileForLocation(location);
            fixedUri = URI.createPlatformResourceURI((String)(String.valueOf(file.getProject().getName()) + File.separator + file.getProjectRelativePath().toString()), (boolean)true);
        }
        return fixedUri;
    }

    private Feature createVariantFeature(VariationPointGroup variationPointGroup, Variant variant) {
        String variantFeatureName = String.valueOf(variationPointGroup.getName()) + "_" + variant.getId();
        Feature feature = this.cachedVariantFeatures.get(variantFeatureName);
        if (feature == null) {
            feature = FeatureFactory.eINSTANCE.createFeature();
            feature.setName(variantFeatureName);
            this.cachedVariantFeatures.put(variantFeatureName, feature);
        }
        return feature;
    }

    private Feature createVariationPointGroupFeature(VariationPointGroup variationPointGroup, Feature parentFeature) {
        Group group = this.createMandatoryFeatureGroup();
        parentFeature.getGroups().add((Object)group);
        Feature feature = FeatureFactory.eINSTANCE.createFeature();
        feature.setName(variationPointGroup.getName());
        group.getChildFeatures().add((Object)feature);
        return feature;
    }

    private Group createMandatoryFeatureGroup() {
        Group group = FeatureFactory.eINSTANCE.createGroup();
        group.setMinCardinality(1);
        group.setMaxCardinality(1);
        return group;
    }

    private FeatureModel initFeatureModel(VariationPointModel vpm, String rootFeatureName) {
        FeatureModel fm = FeatureFactory.eINSTANCE.createFeatureModel();
        Feature rootFeature = FeatureFactory.eINSTANCE.createFeature();
        rootFeature.setName(rootFeatureName);
        fm.setRoot(rootFeature);
        return fm;
    }

    public static FeatureModel loadFeatureModel(File featureModelFile) throws IOException {
        FeaturePackage.eINSTANCE.eClass();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(FEATURE_MODEL_FILE_EXTENSION, new XMIResourceFactoryImpl());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createPlatformResourceURI((String)featureModelFile.getPath(), (boolean)true));
        r.load(null);
        EcoreUtil.resolveAll((ResourceSet)rs);
        EObject model = (EObject)r.getContents().get(0);
        if (!(model instanceof FeatureModel)) {
            throw new IOException("Model is not a valid feature model: " + model.getClass().getName());
        }
        FeatureModel featureModel = (FeatureModel)model;
        return featureModel;
    }

    public static void saveFeatureModel(FeatureModel featureModel, File filePath) throws IOException {
        String featureModelFileExtension = FEATURE_MODEL_FILE_EXTENSION;
        FeatureMapperModelsBuilder.saveModelToPath((EObject)featureModel, filePath, "featureModel", featureModelFileExtension);
    }

    public static void saveMappingModel(FeatureMappingModel mapping, File filePath) throws IOException {
        String fileExtension = FEATURE_MAPPING_FILE_EXTENSION;
        FeatureMapperModelsBuilder.saveModelToPath((EObject)mapping, filePath, "mappingModel", fileExtension);
    }

    private static void saveModelToPath(EObject model, File filePath, String filename, String fileExtension) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put(fileExtension, new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createPlatformResourceURI((String)(String.valueOf(filePath.getPath()) + File.separator + filename + "." + fileExtension), (boolean)true));
        resource.getContents().add((Object)model);
        resource.save(Collections.EMPTY_MAP);
    }

    public void save(FeatureMapperModelSet modelSet, String targetDirectory) {
        File filePath = new File(targetDirectory);
        try {
            FeatureMapperModelsBuilder.saveFeatureModel(modelSet.getFeatureModel(), filePath);
            FeatureMapperModelsBuilder.saveMappingModel(modelSet.getMappingModel(), filePath);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to save feature model", (Throwable)e);
        }
    }
}

