/*
 * Decompiled with CFR 0.152.
 */
package de.devboost.featuremapper.splevo.builder;

import de.devboost.featuremapper.splevo.builder.FeatureMapperModelSet;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.featuremapper.interpreter.emf.EMFInterpreter;
import org.featuremapper.models.feature.Feature;
import org.featuremapper.models.feature.FeatureFactory;
import org.featuremapper.models.feature.FeatureModel;
import org.featuremapper.models.feature.FeaturePackage;
import org.featuremapper.models.feature.Group;
import org.featuremapper.models.featuremapping.ColorMapping;
import org.featuremapper.models.featuremapping.ElementMapping;
import org.featuremapper.models.featuremapping.FeatureMappingFactory;
import org.featuremapper.models.featuremapping.FeatureMappingModel;
import org.featuremapper.models.featuremapping.FeatureModelRef;
import org.featuremapper.models.featuremapping.FeatureRef;
import org.featuremapper.models.featuremapping.SolutionModelRef;
import org.featuremapper.models.featuremapping.Term;
import org.splevo.fm.builder.FeatureModelBuilder;
import org.splevo.fm.builder.FeatureModelWrapper;
import org.splevo.vpm.software.SoftwareElement;
import org.splevo.vpm.variability.Variant;
import org.splevo.vpm.variability.VariationPoint;
import org.splevo.vpm.variability.VariationPointGroup;
import org.splevo.vpm.variability.VariationPointModel;

public class FeatureMapperModelsBuilder
implements FeatureModelBuilder<FeatureMapperModelSet> {
    private static Logger logger = Logger.getLogger(FeatureMapperModelsBuilder.class);
    private Map<String, Feature> cachedVariantFeatures = new HashMap<String, Feature>();
    private Map<Feature, ColorMapping> colorMappings = new HashMap<Feature, ColorMapping>();
    private static final String[] indexcolors = new String[]{"#000000", "#FFFF00", "#1CE6FF", "#FF34FF", "#FF4A46", "#008941", "#006FA6", "#A30059", "#FFDBE5", "#7A4900", "#0000A6", "#63FFAC", "#B79762", "#004D43", "#8FB0FF", "#997D87", "#5A0007", "#809693", "#FEFFE6", "#1B4400", "#4FC601", "#3B5DFF", "#4A3B53", "#FF2F80", "#61615A", "#BA0900", "#6B7900", "#00C2A0", "#FFAA92", "#FF90C9", "#B903AA", "#D16100", "#DDEFFF", "#000035", "#7B4F4B", "#A1C299", "#300018", "#0AA6D8", "#013349", "#00846F", "#372101", "#FFB500", "#C2FFED", "#A079BF", "#CC0744", "#C0B9B2", "#C2FF99", "#001E09", "#00489C", "#6F0062", "#0CBD66", "#EEC3FF", "#456D75", "#B77B68", "#7A87A1", "#788D66", "#885578", "#FAD09F", "#FF8A9A", "#D157A0", "#BEC459", "#456648", "#0086ED", "#886F4C", "#34362D", "#B4A8BD", "#00A6AA", "#452C2C", "#636375", "#A3C8C9", "#FF913F", "#938A81", "#575329", "#00FECF", "#B05B6F", "#8CD0FF", "#3B9700", "#04F757", "#C8A1A1", "#1E6E00", "#7900D7", "#A77500", "#6367A9", "#A05837", "#6B002C", "#772600", "#D790FF", "#9B9700", "#549E79", "#FFF69F", "#201625", "#72418F", "#BC23FF", "#99ADC0", "#3A2465", "#922329", "#5B4534", "#FDE8DC", "#404E55", "#0089A3", "#CB7E98", "#A4E804", "#324E72", "#6A3A4C", "#83AB58", "#001C1E", "#D1F7CE", "#004B28", "#C8D0F6", "#A3A489", "#806C66", "#222800", "#BF5650", "#E83000", "#66796D", "#DA007C", "#FF1A59", "#8ADBB4", "#1E0200", "#5B4E51", "#C895C5", "#320033", "#FF6832", "#66E1D3", "#CFCDAC", "#D0AC94", "#7ED379", "#012C58"};
    public static final String FEATURE_MODEL_FILE_EXTENSION = "feature";
    public static final String FEATURE_MAPPING_FILE_EXTENSION = "featuremapping";

    public String getId() {
        return "de.devboost.featuremapper.splevo.builder";
    }

    public String getLabel() {
        return "FeatureMapper Models Builder";
    }

    public FeatureModelWrapper<FeatureMapperModelSet> build(VariationPointModel vpm, String rootFeatureName) {
        FeatureModel featureModel = this.initFeatureModel(vpm, rootFeatureName);
        FeatureMappingFactory mappingFactory = FeatureMappingFactory.eINSTANCE;
        FeatureMappingModel mappingModel = mappingFactory.createFeatureMappingModel();
        FeatureModelRef fmreference = mappingFactory.createFeatureModelRef();
        mappingModel.setComposerID(new EMFInterpreter().getID());
        mappingModel.setFeatureModel(fmreference);
        fmreference.setValue(featureModel);
        ArrayList<Resource> solutionModelResources = new ArrayList<Resource>();
        for (VariationPointGroup variationPointGroup : vpm.getVariationPointGroups()) {
            Iterator variationPoint2;
            Feature vpFeature;
            this.cachedVariantFeatures.clear();
            if (this.hasMultipleDifferentVariationPoints(variationPointGroup)) {
                vpFeature = this.createVariationPointGroupFeature(variationPointGroup, featureModel.getRoot(), true);
                Group group = this.createFeatureGroup();
                vpFeature.getGroups().add((Object)group);
                group.setMinCardinality(1);
                group.setMaxCardinality(1);
                for (Iterator variationPoint2 : variationPointGroup.getVariationPoints()) {
                    if (!variationPoint2.isRefactored()) continue;
                    for (Variant variant : variationPoint2.getVariants()) {
                        Feature vFeature = this.createVariantFeature(variationPointGroup, variant);
                        vFeature.setMaxCardinality(1);
                        group.getChildFeatures().add((Object)vFeature);
                        this.addFeatureMapping(mappingFactory, mappingModel, solutionModelResources, variant, vFeature);
                    }
                }
                continue;
            }
            vpFeature = this.createVariationPointGroupFeature(variationPointGroup, featureModel.getRoot(), false);
            variationPoint2 = variationPointGroup.getVariationPoints().iterator();
            while (variationPoint2.hasNext()) {
                VariationPoint variationPoint3 = (VariationPoint)variationPoint2.next();
                if (!variationPoint3.isRefactored()) continue;
                for (Variant variant : variationPoint3.getVariants()) {
                    this.addFeatureMapping(mappingFactory, mappingModel, solutionModelResources, variant, vpFeature);
                }
            }
        }
        ArrayList<String> knownResourceUris = new ArrayList<String>();
        for (Resource resource : solutionModelResources) {
            if (resource != null && !resource.getContents().isEmpty()) {
                String uriString = resource.getURI().toString();
                if (knownResourceUris.contains(uriString)) continue;
                knownResourceUris.add(uriString);
                EObject rootObject = (EObject)resource.getContents().get(0);
                SolutionModelRef solutionModelRef = mappingFactory.createSolutionModelRef();
                solutionModelRef.setValue(rootObject);
                mappingModel.getSolutionModels().add((Object)solutionModelRef);
                continue;
            }
            String resourceIdentifier = "unknown resource uri";
            if (resource != null && resource.getURI() != null) {
                resourceIdentifier = resource.getURI().toFileString();
            }
            logger.error((Object)("Could not create solution model reference for resource " + resourceIdentifier));
        }
        this.initialiseColorMappings(this.colorMappings.values());
        FeatureMapperModelSet featureMapperModelSet = new FeatureMapperModelSet(featureModel, mappingModel);
        return new FeatureModelWrapper((Object)featureMapperModelSet, true);
    }

    private void addFeatureMapping(FeatureMappingFactory mappingFactory, FeatureMappingModel mappingModel, List<Resource> solutionModelResources, Variant variant, Feature vFeature) {
        EList softwareEntities = variant.getImplementingElements();
        for (SoftwareElement softwareElement : softwareEntities) {
            this.getOrCreateColorMapping(vFeature, mappingModel);
            ElementMapping mapping = mappingFactory.createElementMapping();
            FeatureRef featureRef = mappingFactory.createFeatureRef();
            featureRef.setFeature(vFeature);
            mapping.setTerm((Term)featureRef);
            EObject wrappedElement = softwareElement.getWrappedElement();
            mapping.setElement(wrappedElement);
            Resource containingResource = wrappedElement.eResource();
            URI fixedUri = this.getFixedURI(containingResource.getURI());
            containingResource.setURI(fixedUri);
            solutionModelResources.add(containingResource);
            mappingModel.getMappings().add((Object)mapping);
        }
    }

    private boolean hasMultipleDifferentVariationPoints(VariationPointGroup variationPointGroup) {
        EList variationPoints = variationPointGroup.getVariationPoints();
        HashSet<String> ids = new HashSet<String>();
        for (VariationPoint variationPoint : variationPoints) {
            EList variants = variationPoint.getVariants();
            for (Variant variant : variants) {
                String id = variant.getId();
                ids.add(id);
            }
            if (ids.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private void initialiseColorMappings(Collection<ColorMapping> values) {
        List<Color> colors = this.createUniqueColors(values.size());
        int i = 0;
        for (ColorMapping colorMapping : values) {
            Color color = colors.get(i);
            colorMapping.setColor((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue());
            ++i;
        }
    }

    private List<Color> createUniqueColors(int size) {
        ArrayList<Color> colors = new ArrayList<Color>();
        int i = 0;
        while (i < size) {
            String hexColor = indexcolors[i + 1];
            Color color = Color.decode(hexColor);
            colors.add(color);
            ++i;
        }
        return colors;
    }

    private void getOrCreateColorMapping(Feature vFeature, FeatureMappingModel mappingModel) {
        if (this.colorMappings.get(vFeature) != null) {
            return;
        }
        FeatureMappingFactory mappingFactory = FeatureMappingFactory.eINSTANCE;
        ColorMapping colorMapping = mappingFactory.createColorMapping();
        FeatureRef term = mappingFactory.createFeatureRef();
        term.setFeature(vFeature);
        colorMapping.setTerm((Term)term);
        mappingModel.getColorMappings().add((Object)colorMapping);
        this.colorMappings.put(vFeature, colorMapping);
    }

    protected URI getFixedURI(URI uri) {
        URI fixedUri = uri;
        if (uri.isFile()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)uri.toFileString());
            IFile file = workspace.getRoot().getFileForLocation(location);
            fixedUri = URI.createPlatformResourceURI((String)(String.valueOf(file.getProject().getName()) + File.separator + file.getProjectRelativePath().toString()), (boolean)true);
        }
        return fixedUri;
    }

    private Feature createVariantFeature(VariationPointGroup variationPointGroup, Variant variant) {
        String variantFeatureName = String.valueOf(variationPointGroup.getName()) + "_" + variant.getId();
        Feature feature = this.cachedVariantFeatures.get(variantFeatureName);
        if (feature == null) {
            feature = FeatureFactory.eINSTANCE.createFeature();
            feature.setName(variantFeatureName);
            this.cachedVariantFeatures.put(variantFeatureName, feature);
        }
        return feature;
    }

    private Feature createVariationPointGroupFeature(VariationPointGroup variationPointGroup, Feature parentFeature, boolean mandatory) {
        Group group = this.createFeatureGroup();
        if (mandatory) {
            group.setMinCardinality(1);
        } else {
            group.setMinCardinality(0);
        }
        group.setMaxCardinality(1);
        parentFeature.getGroups().add((Object)group);
        Feature feature = FeatureFactory.eINSTANCE.createFeature();
        feature.setName(variationPointGroup.getName());
        group.getChildFeatures().add((Object)feature);
        if (mandatory) {
            feature.setMinCardinality(1);
        } else {
            feature.setMinCardinality(0);
        }
        feature.setMaxCardinality(1);
        return feature;
    }

    private Group createFeatureGroup() {
        Group group = FeatureFactory.eINSTANCE.createGroup();
        return group;
    }

    private FeatureModel initFeatureModel(VariationPointModel vpm, String rootFeatureName) {
        FeatureModel fm = FeatureFactory.eINSTANCE.createFeatureModel();
        Feature rootFeature = FeatureFactory.eINSTANCE.createFeature();
        rootFeature.setName(rootFeatureName);
        fm.setRoot(rootFeature);
        return fm;
    }

    public static FeatureModel loadFeatureModel(File featureModelFile) throws IOException {
        FeaturePackage.eINSTANCE.eClass();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(FEATURE_MODEL_FILE_EXTENSION, new XMIResourceFactoryImpl());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createPlatformResourceURI((String)featureModelFile.getPath(), (boolean)true));
        r.load(null);
        EcoreUtil.resolveAll((ResourceSet)rs);
        EObject model = (EObject)r.getContents().get(0);
        if (!(model instanceof FeatureModel)) {
            throw new IOException("Model is not a valid feature model: " + model.getClass().getName());
        }
        FeatureModel featureModel = (FeatureModel)model;
        return featureModel;
    }

    public static void saveFeatureModel(FeatureModel featureModel, File filePath) throws IOException {
        String featureModelFileExtension = FEATURE_MODEL_FILE_EXTENSION;
        FeatureMapperModelsBuilder.saveModelToPath((EObject)featureModel, filePath, "featureModel", featureModelFileExtension);
    }

    public static void saveMappingModel(FeatureMappingModel mapping, File filePath) throws IOException {
        String fileExtension = FEATURE_MAPPING_FILE_EXTENSION;
        FeatureMapperModelsBuilder.saveModelToPath((EObject)mapping, filePath, "mappingModel", fileExtension);
    }

    private static void saveModelToPath(EObject model, File filePath, String filename, String fileExtension) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put(fileExtension, new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createPlatformResourceURI((String)(String.valueOf(filePath.getPath()) + File.separator + filename + "." + fileExtension), (boolean)true));
        resource.getContents().add((Object)model);
        resource.save(Collections.EMPTY_MAP);
    }

    public void save(FeatureMapperModelSet modelSet, String targetDirectory) {
        File filePath = new File(targetDirectory);
        try {
            FeatureMapperModelsBuilder.saveFeatureModel(modelSet.getFeatureModel(), filePath);
            FeatureMapperModelsBuilder.saveMappingModel(modelSet.getMappingModel(), filePath);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to save feature model", (Throwable)e);
        }
    }
}

