/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static final String JDK16_FRAME = "apple.awt.CEmbeddedFrame";
    static final String JDK17_FRAME = "sun.lwawt.macosx.CViewEmbeddedFrame";
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
        System.setProperty("apple.awt.usingSWT", "true");
    }

    static final native int getAWTHandle(Canvas var0);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class[] emptyClass = new Class[]{};
            Object[] emptyObject = new Object[]{};
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", emptyClass);
            if (method != null) {
                method.invoke(clazz, emptyObject);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)parent.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        int handle = parent.view.id;
        Class<?> clazz = null;
        try {
            String className;
            String string = className = embeddedFrameClass != null ? embeddedFrameClass : JDK16_FRAME;
            clazz = embeddedFrameClass == null ? Class.forName(className, true, ClassLoader.getSystemClassLoader()) : Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(JDK17_FRAME);
            }
            catch (ClassNotFoundException cne1) {
                SWT.error(20, cne1);
            }
        }
        catch (Throwable e) {
            SWT.error(1, e, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        Object value = null;
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(Long.TYPE);
            value = constructor.newInstance(new Long(handle));
        }
        catch (Throwable e) {
            SWT.error(20, e);
        }
        final Frame frame = value;
        final boolean isJDK17 = JDK17_FRAME.equals(frame.getClass().getName());
        frame.addNotify();
        parent.setData(EMBEDDED_FRAME_KEY, frame);
        final Listener shellListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = parent.getShell();
        shell.addListener(20, shellListener);
        shell.addListener(19, shellListener);
        final Display display = parent.getDisplay();
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                while (frame.isDisplayable() && !display.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (!display.isDisposed()) {
                    display.removeListener(12, this);
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        Shell shell = parent.getShell();
                        shell.removeListener(20, shellListener);
                        shell.removeListener(19, shellListener);
                        if (isJDK17) {
                            shell.removeListener(26, this);
                            shell.removeListener(27, this);
                        }
                        parent.setVisible(false);
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                try {
                                    this.val$frame.dispose();
                                }
                                catch (Throwable throwable) {}
                            }
                        });
                        break;
                    }
                    case 26: {
                        if (!parent.isFocusControl()) {
                            return;
                        }
                    }
                    case 15: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                if (this.val$frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = this.val$frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)this.val$frame, new Boolean(true));
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        break;
                    }
                    case 16: 
                    case 27: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                if (!this.val$frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = this.val$frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)this.val$frame, new Boolean(false));
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                }
            }
        };
        parent.addListener(15, listener);
        if (isJDK17) {
            parent.addListener(16, listener);
            shell.addListener(26, listener);
            shell.addListener(27, listener);
        } else {
            parent.addListener(27, listener);
        }
        parent.addListener(12, listener);
        display.asyncExec(new Runnable(){

            public void run() {
                if (parent.isDisposed()) {
                    return;
                }
                Rectangle clientArea = parent.getClientArea();
                if (isJDK17) {
                    try {
                        Method method = frame.getClass().getMethod("validateWithBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        if (method != null) {
                            method.invoke((Object)frame, new Integer(clientArea.x), new Integer(clientArea.y), new Integer(clientArea.width), new Integer(clientArea.height));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(this, frame, clientArea){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ Frame val$frame;
                        private final /* synthetic */ Rectangle val$clientArea;
                        {
                            this.this$1 = var1_1;
                            this.val$frame = frame;
                            this.val$clientArea = rectangle;
                        }

                        public void run() {
                            ((Component)this.val$frame).setSize(this.val$clientArea.width, this.val$clientArea.height);
                            this.val$frame.validate();
                            ((Component)this.val$frame).setVisible(false);
                            ((Component)this.val$frame).setVisible(true);
                        }
                    });
                }
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas parent) {
        if (display == null) {
            SWT.error(4);
        }
        if (parent == null) {
            SWT.error(4);
        }
        int handle = 0;
        try {
            SWT_AWT.loadLibrary();
            handle = SWT_AWT.getAWTHandle(parent);
        }
        catch (Throwable e) {
            SWT.error(20, e);
        }
        if (handle == 0) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.cocoa_new(display, handle);
        final ComponentAdapter listener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                display.asyncExec(new Runnable(this, shell, parent){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ Canvas val$parent;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$parent = canvas;
                    }

                    public void run() {
                        if (this.val$shell.isDisposed()) {
                            return;
                        }
                        Dimension dim = this.val$parent.getSize();
                        this.val$shell.setSize(dim.width, dim.height);
                    }
                });
            }
        };
        parent.addComponentListener(listener);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                parent.removeComponentListener(listener);
            }
        });
        shell.setVisible(true);
        return shell;
    }
}

