/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.emf;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ReplacementUtil {
    private static final Logger LOGGER = Logger.getLogger(ReplacementUtil.class);

    public static void replaceCrossReferences(CrossReferenceReplacer processor, ResourceSet ... additionalResourceSets) {
        HashSet crossReferences = new HashSet();
        ArrayList<ResourceSet> resourceSets = new ArrayList<ResourceSet>();
        ReplacementUtil.addResourceSetIfNotNull(processor.getOriginal(), resourceSets);
        ReplacementUtil.addResourceSetIfNotNull(processor.getReplacement(), resourceSets);
        resourceSets.addAll(Lists.newArrayList((Object[])additionalResourceSets));
        for (ResourceSet rs : resourceSets) {
            crossReferences.addAll(EcoreUtil.UsageCrossReferencer.find((EObject)processor.getOriginal(), (ResourceSet)rs));
        }
        for (EStructuralFeature.Setting crossReference : crossReferences) {
            processor.apply(crossReference);
        }
    }

    public static void replaceCrossReferences(EObject original, EObject replacement, ResourceSet ... additionalResourceSets) {
        ReplacementUtil.replaceCrossReferences(new CrossReferenceReplacer(original, replacement), additionalResourceSets);
    }

    private static void addResourceSetIfNotNull(EObject obj, Collection<ResourceSet> rs) {
        if (obj.eResource() != null && obj.eResource().getResourceSet() != null) {
            rs.add(obj.eResource().getResourceSet());
        }
    }

    public static class CrossReferenceReplacer
    implements Function<EStructuralFeature.Setting, Void> {
        private final EObject original;
        private final EObject replacement;

        public CrossReferenceReplacer(EObject original, EObject replacement) {
            this.original = original;
            this.replacement = replacement;
        }

        public EObject getOriginal() {
            return this.original;
        }

        public EObject getReplacement() {
            return this.replacement;
        }

        public Void apply(EStructuralFeature.Setting crossReference) {
            EObject referencingObject = crossReference.getEObject();
            EStructuralFeature referencingFeature = crossReference.getEStructuralFeature();
            if (referencingFeature instanceof EReference && ((EReference)referencingFeature).isContainment()) {
                LOGGER.warn((Object)String.format("There should not be a containment reference from %s (%s) to %s.", referencingObject.toString(), referencingFeature.getName(), this.original.toString()));
                return null;
            }
            if (referencingFeature.getUpperBound() > 1 || referencingFeature.getUpperBound() == -1) {
                Object value = referencingObject.eGet(referencingFeature);
                if (value instanceof List) {
                    List valueList = (List)value;
                    int i = 0;
                    while (i < valueList.size()) {
                        if (valueList.get(i) == this.original) {
                            valueList.set(i, this.replacement);
                        }
                        ++i;
                    }
                } else {
                    LOGGER.warn((Object)String.format("We got a feature with upper bound %d that is no list but %s", referencingFeature.getUpperBound(), value.getClass().getSimpleName()));
                }
            } else {
                referencingObject.eSet(referencingFeature, (Object)this.replacement);
            }
            return null;
        }
    }
}

