/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.emf;

import com.google.common.base.Strings;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.splevo.commons.emf.FileResourceHandling;

public class SPLevoResourceSet
extends ResourceSetImpl {
    public EObject getEObject(URI uri, boolean loadOnDemand) {
        return super.getEObject(this.convertURI(uri), loadOnDemand);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        return super.getResource(this.convertURI(uri), loadOnDemand);
    }

    public Resource createResource(URI uri, String contentType) {
        return super.createResource(this.convertURI(uri), contentType);
    }

    private URI convertURI(URI uri) {
        if (FileResourceHandling.usePlatformResource((ResourceSet)this)) {
            if (uri.isPlatform() || "pathmap".equals(uri.scheme())) {
                return uri;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path p = new Path(uri.toFileString());
            IFile f = root.getFileForLocation((IPath)p);
            return SPLevoResourceSet.createURI(URI.createPlatformResourceURI((String)f.getFullPath().toString(), (boolean)true), uri.fragment());
        }
        if (uri.isPlatform()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource f = root.findMember(uri.toPlatformString(true));
            return URI.createFileURI((String)f.getLocationURI().toString());
        }
        return uri;
    }

    private static URI createURI(URI uri, String fragment) {
        if (Strings.isNullOrEmpty((String)fragment)) {
            return uri;
        }
        return URI.createURI((String)(String.valueOf(uri.toString()) + "#" + fragment), (boolean)true, (int)2);
    }
}

