/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.registry;

import org.apache.log4j.Logger;
import org.splevo.commons.interfaces.IdHavingElement;
import org.splevo.commons.registry.RegistryBase;

public abstract class IdBasedRegistryBase<T extends IdHavingElement<S>, S>
extends RegistryBase<T> {
    private static final Logger LOGGER = Logger.getLogger(IdBasedRegistryBase.class);

    public T getElementById(S id) {
        for (IdHavingElement element : this.elements) {
            if (!element.getId().equals(id)) continue;
            return (T)element;
        }
        return null;
    }

    @Override
    protected boolean isValid(T element) {
        if (element == null) {
            LOGGER.warn((Object)"Tried to register null element");
            return false;
        }
        if (element.getId() == null) {
            LOGGER.warn((Object)("Tried to register element without id " + element));
            return false;
        }
        return true;
    }

    @Override
    protected boolean areElementsConsideredTheSame(T element1, T element2) {
        return element1.getId().equals(element2.getId());
    }
}

