/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.diffing;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.splevo.commons.emf.SPLevoResourceSet;
import org.splevo.diffing.DiffingModelUtil;

public class DiffingModelUtilTest {
    private TemporaryFolder folder = null;

    @BeforeClass
    public static void setUpBefore() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Before
    public void setUp() throws IOException {
        this.folder = new TemporaryFolder();
        this.folder.create();
    }

    @After
    public void tearDown() {
        this.folder.delete();
    }

    @Test
    public void testLoadModel() throws IOException {
        String modelPath = "testmodel/singlediffmodel.diff";
        File modelFile = new File(modelPath).getAbsoluteFile();
        SPLevoResourceSet rs = new SPLevoResourceSet();
        DiffingModelUtil.loadModel((File)modelFile, (ResourceSet)rs);
        Resource resource = (Resource)rs.getResources().get(0);
        EObject rootObject = (EObject)resource.getContents().get(0);
        Assert.assertThat((Object)rootObject, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Comparison.class)));
    }

    @Test
    public void testSave() throws IOException {
        File modelFilePath = new File(String.valueOf(this.folder.getRoot().getAbsolutePath()) + File.separator + "testmodelsave.diff");
        Comparison model = CompareFactory.eINSTANCE.createComparison();
        Diff diff = CompareFactory.eINSTANCE.createDiff();
        model.getDifferences().add((Object)diff);
        DiffingModelUtil.save((Comparison)model, (File)modelFilePath);
        Assert.assertThat((Object)modelFilePath.exists(), (Matcher)CoreMatchers.is((Object)true));
    }
}

