/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.diffing;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.splevo.commons.emf.SPLevoResourceSet;

public class DiffingModelUtil {
    public static Comparison loadModel(File filePath, ResourceSet rs) throws IOException {
        ComparePackage.eINSTANCE.eClass();
        String fileExtension = DiffingModelUtil.getFileExtension(filePath);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        URI uri = null;
        uri = filePath.isAbsolute() ? URI.createFileURI((String)filePath.getPath()) : URI.createPlatformResourceURI((String)filePath.getPath(), (boolean)false);
        Resource r = rs.createResource(uri);
        r.load(null);
        EObject model = (EObject)r.getContents().get(0);
        if (!(model instanceof Comparison)) {
            throw new IOException("Model is not a valid SPLevoProject: " + model.getClass().getName());
        }
        Comparison comparisionModel = (Comparison)model;
        return comparisionModel;
    }

    private static String getFileExtension(File file) {
        String path = file.toString();
        if (path == null) {
            return null;
        }
        String fileExtension = path.substring(path.lastIndexOf(46) + 1);
        return fileExtension;
    }

    public static void save(Comparison comparisonModel, File filePath) throws IOException {
        String fileExtension = DiffingModelUtil.getFileExtension(filePath);
        SPLevoResourceSet resSet = new SPLevoResourceSet();
        Map m = resSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        m.put(fileExtension, new XMIResourceFactoryImpl());
        URI uri = null;
        uri = filePath.isAbsolute() ? URI.createFileURI((String)filePath.getPath()) : URI.createPlatformResourceURI((String)filePath.getPath(), (boolean)false);
        Resource resource = resSet.createResource(uri);
        resource.getContents().add((Object)comparisonModel);
        resource.save(Collections.EMPTY_MAP);
    }
}

